/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class JavaHelper {
    private static List<JavaVersion> javaVersionsCache;
    public static final List<String> javaFxModules;

    public static Path tryGetOpenJFXPath(Path path) {
        Path path2;
        String string = path.getFileName().toString();
        Path path3 = path.getParent();
        if (path3 == null) {
            return null;
        }
        Path path4 = path3.resolve(string.replace("openjdk", "openjfx"));
        if (Files.isDirectory(path4, new LinkOption[0])) {
            return path4;
        }
        Path path5 = path3.resolve(string.replace("jdk", "openjfx"));
        if (Files.isDirectory(path5, new LinkOption[0])) {
            return path5;
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX && Files.isDirectory(path2 = Paths.get("/usr/share/openjfx", new String[0]), new LinkOption[0])) {
            return path2;
        }
        return null;
    }

    public static Path tryFindModule(Path path, String string) {
        Path path2 = path.resolve(string.concat(".jar"));
        if (IOHelper.isFile(path2)) {
            return path2;
        }
        path2 = path.resolve("lib").resolve(string.concat(".jar"));
        if (!IOHelper.isFile(path2)) {
            return null;
        }
        return path2;
    }

    public static boolean tryAddModule(List<Path> list, String string, StringBuilder stringBuilder) {
        for (Path path : list) {
            Path path2;
            if (path == null || (path2 = JavaHelper.tryFindModule(path, string)) == null) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append(File.pathSeparatorChar);
            }
            stringBuilder.append(path2.toAbsolutePath());
            return true;
        }
        return false;
    }

    public static synchronized List<JavaVersion> findJava() {
        if (javaVersionsCache != null) {
            return javaVersionsCache;
        }
        ArrayList<String> arrayList = new ArrayList<String>(4);
        ArrayList<JavaVersion> arrayList2 = new ArrayList<JavaVersion>(4);
        JavaHelper.tryAddJava(arrayList, arrayList2, JavaVersion.getCurrentJavaVersion());
        String[] stringArray = System.getenv("PATH").split(JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE ? ";" : ":");
        for (String string : stringArray) {
            try {
                Path path;
                Path path2 = Paths.get(string, new String[0]);
                Path path3 = path = JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE ? path2.resolve("java.exe") : path2.resolve("java");
                if (!Files.exists(path, new LinkOption[0]) || (path2 = (path = path.toRealPath(new LinkOption[0])).getParent().getParent()) == null) continue;
                JavaHelper.tryAddJava(arrayList, arrayList2, JavaVersion.getByPath(path2));
                JavaHelper.trySearchJava(arrayList, arrayList2, path2.getParent());
            }
            catch (NullPointerException | InvalidPathException runtimeException) {
            }
            catch (IOException iOException) {
                LogHelper.error(iOException);
            }
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE) {
            Path path = IOHelper.getRoot();
            try {
                JavaHelper.trySearchJava(arrayList, arrayList2, path.resolve("Program Files").resolve("Java"));
                JavaHelper.trySearchJava(arrayList, arrayList2, path.resolve("Program Files").resolve("AdoptOpenJDK"));
                JavaHelper.trySearchJava(arrayList, arrayList2, path.resolve("Program Files").resolve("Eclipse Foundation"));
                JavaHelper.trySearchJava(arrayList, arrayList2, path.resolve("Program Files").resolve("BellSoft"));
            }
            catch (IOException iOException) {
                LogHelper.error(iOException);
            }
        } else if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
            try {
                JavaHelper.trySearchJava(arrayList, arrayList2, Paths.get("/usr/lib/jvm", new String[0]));
            }
            catch (IOException iOException) {
                LogHelper.error(iOException);
            }
        }
        javaVersionsCache = arrayList2;
        return arrayList2;
    }

    private static JavaVersion tryFindJavaByPath(Path path) {
        if (javaVersionsCache == null) {
            return null;
        }
        for (JavaVersion javaVersion : javaVersionsCache) {
            if (!javaVersion.jvmDir.equals(path)) continue;
            return javaVersion;
        }
        return null;
    }

    public static void tryAddJava(List<String> list, List<JavaVersion> list2, JavaVersion javaVersion) {
        if (javaVersion == null) {
            return;
        }
        Path path = javaVersion.jvmDir.toAbsolutePath();
        try {
            path = path.toRealPath(new LinkOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = path.toString();
        if (list.contains(string)) {
            return;
        }
        list.add(string);
        list2.add(javaVersion);
    }

    public static void trySearchJava(List<String> list, List<JavaVersion> list2, Path path2) throws IOException {
        if (path2 == null || !Files.isDirectory(path2, new LinkOption[0])) {
            return;
        }
        Files.list(path2).filter(path -> Files.exists(path.resolve("bin").resolve(JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE ? "java.exe" : "java"), new LinkOption[0])).forEach(path -> {
            JavaHelper.tryAddJava(list, list2, JavaVersion.getByPath(path));
            if (Files.exists(path.resolve("jre"), new LinkOption[0])) {
                JavaHelper.tryAddJava(list, list2, JavaVersion.getByPath(path.resolve("jre")));
            }
        });
    }

    public static JavaVersionAndBuild getJavaVersion(String string) {
        JavaVersionAndBuild javaVersionAndBuild = new JavaVersionAndBuild();
        if (string.startsWith("1.")) {
            javaVersionAndBuild.version = Integer.parseInt(string.substring(2, 3));
            int n = string.indexOf(95);
            if (n != -1) {
                javaVersionAndBuild.build = Integer.parseInt(string.substring(n + 1));
            }
        } else {
            int n = string.indexOf(".");
            if (n != -1) {
                javaVersionAndBuild.version = Integer.parseInt(string.substring(0, n));
                n = string.lastIndexOf(".");
                javaVersionAndBuild.build = Integer.parseInt(string.substring(n + 1));
            } else {
                try {
                    if (string.endsWith("-ea")) {
                        string = string.substring(0, string.length() - 3);
                    }
                    javaVersionAndBuild.version = Integer.parseInt(string);
                    javaVersionAndBuild.build = 0;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return javaVersionAndBuild;
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("javafx.base");
        arrayList.add("javafx.graphics");
        arrayList.add("javafx.fxml");
        arrayList.add("javafx.controls");
        arrayList.add("javafx.swing");
        arrayList.add("javafx.media");
        arrayList.add("javafx.web");
        javaFxModules = Collections.unmodifiableList(arrayList);
    }

    public static class JavaVersion {
        public final Path jvmDir;
        public final int version;
        public final int build;
        public final JVMHelper.ARCH arch;
        public final List<String> modules;
        public boolean enabledJavaFX;

        public JavaVersion(Path path, int n, int n2, JVMHelper.ARCH aRCH, boolean bl) {
            this.jvmDir = path;
            this.version = n;
            this.build = n2;
            this.arch = aRCH;
            this.enabledJavaFX = bl;
            this.modules = n > 8 ? javaFxModules : Collections.unmodifiableList(new ArrayList());
        }

        public JavaVersion(Path path, int n, int n2, JVMHelper.ARCH aRCH, List<String> list, boolean bl) {
            this.jvmDir = path;
            this.version = n;
            this.build = n2;
            this.arch = aRCH;
            this.modules = list;
            this.enabledJavaFX = bl;
        }

        public static JavaVersion getCurrentJavaVersion() {
            return new JavaVersion(Paths.get(System.getProperty("java.home"), new String[0]), JVMHelper.getVersion(), JVMHelper.JVM_BUILD, JVMHelper.ARCH_TYPE, JavaVersion.isCurrentJavaSupportJavaFX());
        }

        private static boolean isCurrentJavaSupportJavaFX() {
            try {
                Class.forName("javafx.application.Application");
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (JVMHelper.getVersion() > 8) {
                    Path path = Paths.get(System.getProperty("java.home"), new String[0]);
                    return JavaHelper.tryFindModule(path, "javafx.base") != null;
                }
                return false;
            }
        }

        public static JavaVersion getByPath(Path path) {
            Object object;
            Object object2 = JavaHelper.tryFindJavaByPath(path);
            if (object2 != null) {
                return object2;
            }
            object2 = path.resolve("release");
            JavaVersionAndBuild javaVersionAndBuild = null;
            ArrayList<String> arrayList = null;
            JVMHelper.ARCH aRCH = JVMHelper.ARCH_TYPE;
            if (IOHelper.isFile((Path)object2)) {
                try {
                    String string;
                    object = new Properties();
                    ((Properties)object).load(IOHelper.newReader((Path)object2));
                    String string2 = JavaVersion.getProperty((Properties)object, "JAVA_VERSION");
                    if (string2 != null) {
                        javaVersionAndBuild = JavaHelper.getJavaVersion(string2);
                    }
                    try {
                        string = JavaVersion.getProperty((Properties)object, "OS_ARCH");
                        if (string != null) {
                            aRCH = JVMHelper.getArch(string);
                        }
                    }
                    catch (Throwable throwable) {
                        aRCH = null;
                    }
                    string = JavaVersion.getProperty((Properties)object, "MODULES");
                    if (string != null) {
                        arrayList = new ArrayList<String>(Arrays.asList(string.split(" ")));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (javaVersionAndBuild == null) {
                javaVersionAndBuild = new JavaVersionAndBuild(JavaVersion.isExistExtJavaLibrary(path, "rt") ? 8 : 9, 0);
            }
            object = new JavaVersion(path, javaVersionAndBuild.version, javaVersionAndBuild.build, aRCH, false);
            if (javaVersionAndBuild.version <= 8) {
                ((JavaVersion)object).enabledJavaFX = JavaVersion.isExistExtJavaLibrary(path, "jfxrt");
            } else {
                if (arrayList != null) {
                    ((JavaVersion)object).enabledJavaFX = arrayList.contains("javafx.base");
                }
                if (!((JavaVersion)object).enabledJavaFX) {
                    boolean bl = ((JavaVersion)object).enabledJavaFX = JavaHelper.tryFindModule(path, "javafx.base") != null;
                    if (!((JavaVersion)object).enabledJavaFX) {
                        ((JavaVersion)object).enabledJavaFX = JavaHelper.tryFindModule(path.resolve("jre"), "javafx.base") != null;
                    }
                }
            }
            return object;
        }

        private static String getProperty(Properties properties, String string) {
            String string2 = properties.getProperty(string);
            if (string2 == null) {
                return null;
            }
            return string2.replaceAll("\"", "");
        }

        public static boolean isExistExtJavaLibrary(Path path, String string) {
            Path path2 = path.resolve("lib").resolve("ext").resolve(string.concat(".jar"));
            Path path3 = path.resolve("lib").resolve(string.concat(".jar"));
            Path path4 = path.resolve("jre").resolve("lib").resolve("ext").resolve(string.concat(".jar"));
            Path path5 = path.resolve("jre").resolve("lib").resolve(string.concat(".jar"));
            return IOHelper.isFile(path2) || IOHelper.isFile(path4) || IOHelper.isFile(path5) || IOHelper.isFile(path3);
        }
    }

    public static class JavaVersionAndBuild {
        public int version;
        public int build;

        public JavaVersionAndBuild(int n, int n2) {
            this.version = n;
            this.build = n2;
        }

        public JavaVersionAndBuild() {
        }
    }
}

