/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.authlib.AuthenticationService;
import com.mojang.authlib.Environment;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.SignatureState;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.minecraft.InsecurePublicKeyException;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftProfileTextures;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.events.request.CheckServerRequestEvent;
import pro.gravit.launcher.events.request.JoinServerRequestEvent;
import pro.gravit.launcher.events.request.ProfileByUUIDRequestEvent;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launcher.profiles.Texture;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.auth.CheckServerRequest;
import pro.gravit.launcher.request.auth.JoinServerRequest;
import pro.gravit.launcher.request.uuid.ProfileByUUIDRequest;
import pro.gravit.utils.helper.SecurityHelper;

public class YggdrasilMinecraftSessionService
implements MinecraftSessionService {
    public static final boolean NO_TEXTURES = Boolean.getBoolean("launcher.com.mojang.authlib.noTextures");
    private static final Type TEXTURES_TYPE_TOKEN = new TypeToken<Map<MinecraftProfileTexture.Type, MinecraftProfileTexture>>(){}.getType();
    private static final Gson GSON = new GsonBuilder().create();
    private static final Logger logger = LogManager.getLogger(YggdrasilMinecraftSessionService.class);

    public YggdrasilMinecraftSessionService(AuthenticationService service, Environment environment) {
        logger.debug("Patched MinecraftSessionService created");
    }

    public YggdrasilMinecraftSessionService(YggdrasilAuthenticationService service, Environment environment) {
        logger.debug("Patched MinecraftSessionService created");
    }

    protected YggdrasilMinecraftSessionService(ServicesKeySet servicesKeySet, Proxy proxy, Environment env) {
        logger.debug("Patched MinecraftSessionService created");
    }

    public static void fillTextureProperties(GameProfile profile, PlayerProfile pp) {
        logger.debug("fillTextureProperties, Username: '{}'", (Object)profile.getName());
        if (NO_TEXTURES) {
            return;
        }
        HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture> textures = new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        try {
            if (pp.assets != null) {
                for (MinecraftProfileTexture.Type type : MinecraftProfileTexture.Type.values()) {
                    String name = type.name();
                    Texture texture = (Texture)pp.assets.get(name);
                    if (texture == null) continue;
                    textures.put(type, YggdrasilMinecraftSessionService.makeMinecraftTexture(texture));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MinecraftTexturesProperty payload = new MinecraftTexturesProperty();
        payload.textures = textures;
        payload.isPublic = true;
        payload.profileId = pp.uuid.toString().replace("-", "");
        payload.profileName = pp.username;
        String serializedData = Base64.getEncoder().encodeToString(GSON.toJson((Object)payload).getBytes(StandardCharsets.UTF_8));
        logger.debug("Write textures {}", (Object)serializedData);
        Property textureProperty = new Property("textures", serializedData, "");
        profile.getProperties().put("textures", textureProperty);
    }

    private static MinecraftProfileTexture makeMinecraftTexture(Texture texture) {
        return new MinecraftProfileTexture(texture.url, SecurityHelper.toHex((byte[])texture.digest), texture.metadata);
    }

    public static GameProfile toGameProfile(PlayerProfile pp) {
        GameProfile profile = new GameProfile(pp.uuid, pp.username);
        try {
            if (pp.properties != null) {
                PropertyMap propertyMap = profile.getProperties();
                for (Map.Entry prop : pp.properties.entrySet()) {
                    propertyMap.put((String)prop.getKey(), new Property((String)prop.getKey(), (String)prop.getValue(), ""));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        YggdrasilMinecraftSessionService.fillTextureProperties(profile, pp);
        return profile;
    }

    public static ProfileResult toProfileResult(PlayerProfile pp) {
        return new ProfileResult(YggdrasilMinecraftSessionService.toGameProfile(pp), Set.of());
    }

    @Override
    public String getSecurePropertyValue(Property property) throws InsecurePublicKeyException {
        return property.value();
    }

    @Override
    @Nullable
    public ProfileResult fetchProfile(UUID profileId, boolean requireSecure) {
        PlayerProfile pp;
        logger.debug("fillProfileProperties, UUID: {}", (Object)profileId);
        if (profileId == null) {
            return null;
        }
        try {
            pp = ((ProfileByUUIDRequestEvent)new ProfileByUUIDRequest((UUID)profileId).request()).playerProfile;
        }
        catch (Exception e) {
            logger.warn("Couldn't fetch profile properties for '{}': {}", (Object)profileId, e instanceof RequestException ? e.getMessage() : e);
            return null;
        }
        if (pp == null) {
            logger.warn("Couldn't fetch profile properties for '{}' as the profile does not exist", (Object)profileId);
            return null;
        }
        logger.debug("Successfully fetched profile properties for '{}'", (Object)profileId);
        return YggdrasilMinecraftSessionService.toProfileResult(pp);
    }

    public ProfileResult hasJoinedServer(String username, String serverID) throws AuthenticationUnavailableException {
        PlayerProfile pp;
        logger.debug("checkServer, Username: '{}', Server ID: {}", (Object)username, (Object)serverID);
        try {
            pp = ((CheckServerRequestEvent)new CheckServerRequest((String)username, (String)serverID).request()).playerProfile;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new AuthenticationUnavailableException(e);
        }
        return pp == null ? null : YggdrasilMinecraftSessionService.toProfileResult(pp);
    }

    @Override
    public ProfileResult hasJoinedServer(String username, String serverID, InetAddress address) throws AuthenticationUnavailableException {
        return this.hasJoinedServer(username, serverID);
    }

    @Override
    public Property getPackedTextures(GameProfile profile) {
        return (Property)Iterables.getFirst((Iterable)profile.getProperties().get("textures"), null);
    }

    @Override
    public MinecraftProfileTextures unpackTextures(Property packedTextures) {
        if (packedTextures == null) {
            return MinecraftProfileTextures.EMPTY;
        }
        logger.trace("Read textures property {}", (Object)packedTextures.value());
        String serializedData = new String(Base64.getDecoder().decode(packedTextures.value()), StandardCharsets.UTF_8);
        MinecraftTexturesProperty payload = (MinecraftTexturesProperty)GSON.fromJson(serializedData, MinecraftTexturesProperty.class);
        Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> texturesMap = payload.textures;
        if (texturesMap == null) {
            return MinecraftProfileTextures.EMPTY;
        }
        return new MinecraftProfileTextures(texturesMap.get((Object)MinecraftProfileTexture.Type.SKIN), texturesMap.get((Object)MinecraftProfileTexture.Type.CAPE), texturesMap.get((Object)MinecraftProfileTexture.Type.ELYTRA), SignatureState.SIGNED);
    }

    @Override
    public void joinServer(UUID uuid, String accessToken, String serverID) throws AuthenticationException {
        boolean success;
        logger.debug("joinServer, UUID: '{}', Access token: {}, Server ID: {}", (Object)uuid, (Object)accessToken, (Object)serverID);
        try {
            success = ((JoinServerRequestEvent)new JoinServerRequest((UUID)uuid, (String)accessToken, (String)serverID).request()).allow;
        }
        catch (RequestException e) {
            throw new AuthenticationException(String.format("RequestException: '%s'. Please restart the launcher and client and try again", e.getMessage()));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new AuthenticationUnavailableException(e);
        }
        if (!success) {
            throw new AuthenticationException("Failed to verify username (Clientside). Please restart the launcher and client");
        }
    }

    public static class MinecraftTexturesProperty {
        public long timestamp;
        public String profileId;
        public String profileName;
        public boolean isPublic;
        public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> textures;

        public MinecraftTexturesProperty() {
        }

        public MinecraftTexturesProperty(long timestamp, String profileId, String profileName, boolean isPublic, Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> textures) {
            this.timestamp = timestamp;
            this.profileId = profileId;
            this.profileName = profileName;
            this.isPublic = isPublic;
            this.textures = textures;
        }
    }
}

