/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.mappingio;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.impl.lib.mappingio.format.MappingFormat;
import org.jetbrains.annotations.Nullable;

public final class MappingReader {
    @Nullable
    public static MappingFormat detectFormat(Reader reader) throws IOException {
        int pos;
        int len;
        char[] buffer = new char[4096];
        BufferedReader br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        br.mark(4096);
        for (pos = 0; pos < buffer.length && (len = br.read(buffer, pos, buffer.length - pos)) >= 0; pos += len) {
        }
        br.reset();
        if (pos < 3) {
            return null;
        }
        switch (String.valueOf(buffer, 0, 3)) {
            case "v1\t": {
                return MappingFormat.TINY_FILE;
            }
            case "tin": {
                return MappingFormat.TINY_2_FILE;
            }
            case "tsr": {
                return MappingFormat.TSRG_2_FILE;
            }
            case "CLA": {
                return MappingFormat.ENIGMA_FILE;
            }
            case "PK:": 
            case "CL:": 
            case "MD:": 
            case "FD:": {
                return MappingReader.detectSrgOrXsrg(br);
            }
        }
        String headerStr = String.valueOf(buffer, 0, pos);
        if (headerStr.contains(" -> ")) {
            return MappingFormat.PROGUARD_FILE;
        }
        if (headerStr.contains("\n\t")) {
            return MappingFormat.TSRG_FILE;
        }
        return null;
    }

    private static MappingFormat detectSrgOrXsrg(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith("FD:")) continue;
            String[] parts = line.split(" ");
            if (parts.length < 5) break;
            if (MappingReader.isEmptyOrStartsWithHash(parts[3]) || MappingReader.isEmptyOrStartsWithHash(parts[4])) continue;
            return MappingFormat.XSRG_FILE;
        }
        return MappingFormat.SRG_FILE;
    }

    private static boolean isEmptyOrStartsWithHash(String string) {
        return string.isEmpty() || string.startsWith("#");
    }
}

