/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.batchedentityrendering.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.jellysquid.mods.sodium.client.render.vertex.buffer.ExtendedBufferBuilder;
import me.jellysquid.mods.sodium.client.render.vertex.buffer.SodiumBufferBuilder;
import net.coderbot.batchedentityrendering.impl.BlendingStateHolder;
import net.coderbot.batchedentityrendering.impl.BufferSegment;
import net.coderbot.batchedentityrendering.impl.BufferSegmentRenderer;
import net.coderbot.batchedentityrendering.impl.Groupable;
import net.coderbot.batchedentityrendering.impl.MemoryTrackingBuffer;
import net.coderbot.batchedentityrendering.impl.SegmentedBufferBuilder;
import net.coderbot.batchedentityrendering.impl.TransparencyType;
import net.coderbot.batchedentityrendering.impl.ordering.GraphTranslucencyRenderOrderManager;
import net.coderbot.batchedentityrendering.impl.ordering.RenderOrderManager;
import net.coderbot.iris.fantastic.WrappingMultiBufferSource;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public class FullyBufferedMultiBufferSource
extends class_4597.class_4598
implements MemoryTrackingBuffer,
Groupable,
WrappingMultiBufferSource {
    private static final int NUM_BUFFERS = 32;
    private final RenderOrderManager renderOrderManager;
    private final SegmentedBufferBuilder[] builders;
    private final LinkedHashMap<class_1921, Integer> affinities;
    private int drawCalls;
    private int renderTypes;
    private final BufferSegmentRenderer segmentRenderer;
    private final UnflushableWrapper unflushableWrapper;
    private final List<Function<class_1921, class_1921>> wrappingFunctionStack;
    private Function<class_1921, class_1921> wrappingFunction = null;
    private boolean isReady;
    private Map<class_1921, List<BufferSegment>> typeToSegment = new HashMap<class_1921, List<BufferSegment>>();
    private List<class_1921> renderOrder = new ArrayList<class_1921>();

    public FullyBufferedMultiBufferSource() {
        super(new class_287(0), Collections.emptyMap());
        this.renderOrderManager = new GraphTranslucencyRenderOrderManager();
        this.builders = new SegmentedBufferBuilder[32];
        for (int i = 0; i < this.builders.length; ++i) {
            this.builders[i] = new SegmentedBufferBuilder();
        }
        this.affinities = new LinkedHashMap(32, 0.75f, true);
        this.drawCalls = 0;
        this.segmentRenderer = new BufferSegmentRenderer();
        this.unflushableWrapper = new UnflushableWrapper(this);
        this.wrappingFunctionStack = new ArrayList<Function<class_1921, class_1921>>();
    }

    public class_4588 getBuffer(class_1921 class_19212) {
        SodiumBufferBuilder sodiumBufferBuilder;
        Object object;
        Object object2;
        this.removeReady();
        if (this.wrappingFunction != null) {
            class_19212 = this.wrappingFunction.apply(class_19212);
        }
        this.renderOrderManager.begin(class_19212);
        Integer n = this.affinities.get(class_19212);
        if (n == null) {
            if (this.affinities.size() < this.builders.length) {
                n = this.affinities.size();
            } else {
                object2 = this.affinities.entrySet().iterator();
                object = (Map.Entry)object2.next();
                object2.remove();
                this.affinities.remove(object.getKey());
                n = (Integer)object.getValue();
            }
            this.affinities.put(class_19212, n);
        }
        if ((object2 = this.builders[n].getBuffer(class_19212)) instanceof ExtendedBufferBuilder && (sodiumBufferBuilder = (object = (ExtendedBufferBuilder)object2).sodium$getDelegate()) != null) {
            return sodiumBufferBuilder;
        }
        return object2;
    }

    private void removeReady() {
        this.isReady = false;
        this.typeToSegment.clear();
        this.renderOrder.clear();
    }

    public void readyUp() {
        this.isReady = true;
        class_3695 class_36952 = class_310.method_1551().method_16011();
        class_36952.method_15396("collect");
        for (SegmentedBufferBuilder segmentedBufferBuilder : this.builders) {
            List<BufferSegment> list = segmentedBufferBuilder.getSegments();
            for (BufferSegment bufferSegment : list) {
                this.typeToSegment.computeIfAbsent(bufferSegment.type(), class_19212 -> new ArrayList()).add(bufferSegment);
            }
        }
        class_36952.method_15405("resolve ordering");
        this.renderOrder = this.renderOrderManager.getRenderOrder();
        this.renderOrderManager.reset();
        this.affinities.clear();
        class_36952.method_15407();
    }

    public void method_22993() {
        class_3695 class_36952 = class_310.method_1551().method_16011();
        if (!this.isReady) {
            this.readyUp();
        }
        class_36952.method_15396("draw buffers");
        for (class_1921 class_19212 : this.renderOrder) {
            class_19212.method_23516();
            ++this.renderTypes;
            for (BufferSegment bufferSegment : this.typeToSegment.getOrDefault(class_19212, Collections.emptyList())) {
                this.segmentRenderer.drawInner(bufferSegment);
                ++this.drawCalls;
            }
            class_19212.method_23518();
        }
        class_36952.method_15405("reset");
        this.removeReady();
        class_36952.method_15407();
    }

    public void endBatchWithType(TransparencyType transparencyType) {
        class_3695 class_36952 = class_310.method_1551().method_16011();
        if (!this.isReady) {
            this.readyUp();
        }
        class_36952.method_15396("draw buffers");
        ArrayList<class_1921> arrayList = new ArrayList<class_1921>();
        for (class_1921 class_19212 : this.renderOrder) {
            if (((BlendingStateHolder)class_19212).getTransparencyType() != transparencyType) continue;
            arrayList.add(class_19212);
            class_19212.method_23516();
            ++this.renderTypes;
            for (BufferSegment bufferSegment : this.typeToSegment.getOrDefault(class_19212, Collections.emptyList())) {
                this.segmentRenderer.drawInner(bufferSegment);
                ++this.drawCalls;
            }
            this.typeToSegment.remove(class_19212);
            class_19212.method_23518();
        }
        class_36952.method_15405("reset type " + transparencyType);
        this.renderOrder.removeAll(arrayList);
        class_36952.method_15407();
    }

    public int getDrawCalls() {
        return this.drawCalls;
    }

    public int getRenderTypes() {
        return this.renderTypes;
    }

    public void resetDrawCalls() {
        this.drawCalls = 0;
        this.renderTypes = 0;
    }

    public void method_22994(class_1921 class_19212) {
    }

    public class_4597.class_4598 getUnflushableWrapper() {
        return this.unflushableWrapper;
    }

    @Override
    public int getAllocatedSize() {
        int n = 0;
        for (SegmentedBufferBuilder segmentedBufferBuilder : this.builders) {
            n += segmentedBufferBuilder.getAllocatedSize();
        }
        return n;
    }

    @Override
    public int getUsedSize() {
        int n = 0;
        for (SegmentedBufferBuilder segmentedBufferBuilder : this.builders) {
            n += segmentedBufferBuilder.getUsedSize();
        }
        return n;
    }

    @Override
    public void freeAndDeleteBuffer() {
        for (SegmentedBufferBuilder segmentedBufferBuilder : this.builders) {
            segmentedBufferBuilder.freeAndDeleteBuffer();
        }
    }

    @Override
    public void startGroup() {
        this.renderOrderManager.startGroup();
    }

    @Override
    public boolean maybeStartGroup() {
        return this.renderOrderManager.maybeStartGroup();
    }

    @Override
    public void endGroup() {
        this.renderOrderManager.endGroup();
    }

    @Override
    public void pushWrappingFunction(Function<class_1921, class_1921> function) {
        if (this.wrappingFunction != null) {
            this.wrappingFunctionStack.add(this.wrappingFunction);
        }
        this.wrappingFunction = function;
    }

    @Override
    public void popWrappingFunction() {
        this.wrappingFunction = this.wrappingFunctionStack.isEmpty() ? null : this.wrappingFunctionStack.remove(this.wrappingFunctionStack.size() - 1);
    }

    @Override
    public void assertWrapStackEmpty() {
        if (!this.wrappingFunctionStack.isEmpty() || this.wrappingFunction != null) {
            throw new IllegalStateException("Wrapping function stack not empty!");
        }
    }

    private static class UnflushableWrapper
    extends class_4597.class_4598
    implements Groupable {
        private final FullyBufferedMultiBufferSource wrapped;

        UnflushableWrapper(FullyBufferedMultiBufferSource fullyBufferedMultiBufferSource) {
            super(new class_287(0), Collections.emptyMap());
            this.wrapped = fullyBufferedMultiBufferSource;
        }

        public class_4588 getBuffer(class_1921 class_19212) {
            return this.wrapped.getBuffer(class_19212);
        }

        public void method_22993() {
        }

        public void method_22994(class_1921 class_19212) {
        }

        @Override
        public void startGroup() {
            this.wrapped.startGroup();
        }

        @Override
        public boolean maybeStartGroup() {
            return this.wrapped.maybeStartGroup();
        }

        @Override
        public void endGroup() {
            this.wrapped.endGroup();
        }
    }
}

