/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.postprocess;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.coderbot.iris.features.FeatureFlags;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.image.GlImage;
import net.coderbot.iris.gl.program.ComputeProgram;
import net.coderbot.iris.gl.program.Program;
import net.coderbot.iris.gl.program.ProgramBuilder;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.gl.sampler.SamplerHolder;
import net.coderbot.iris.gl.sampler.SamplerLimits;
import net.coderbot.iris.gl.shader.ShaderCompileException;
import net.coderbot.iris.gl.texture.TextureAccess;
import net.coderbot.iris.pipeline.ShaderPrinter;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.TransformPatcher;
import net.coderbot.iris.postprocess.BufferFlipper;
import net.coderbot.iris.postprocess.CenterDepthSampler;
import net.coderbot.iris.postprocess.FullScreenQuadRenderer;
import net.coderbot.iris.rendertarget.RenderTarget;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.samplers.IrisImages;
import net.coderbot.iris.samplers.IrisSamplers;
import net.coderbot.iris.shaderpack.ComputeSource;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.ProgramDirectives;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.texture.TextureStage;
import net.coderbot.iris.shadows.ShadowRenderTargets;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.custom.CustomUniforms;
import net.minecraft.class_276;
import net.minecraft.class_310;

public class CompositeRenderer {
    private final RenderTargets renderTargets;
    private final ImmutableList<Pass> passes;
    private final TextureAccess noiseTexture;
    private final FrameUpdateNotifier updateNotifier;
    private final CenterDepthSampler centerDepthSampler;
    private final Object2ObjectMap<String, TextureAccess> customTextureIds;
    private final ImmutableSet<Integer> flippedAtLeastOnceFinal;
    private final CustomUniforms customUniforms;
    private final Object2ObjectMap<String, TextureAccess> irisCustomTextures;
    private final Set<GlImage> customImages;
    private TextureStage textureStage;
    private WorldRenderingPipeline pipeline;

    public CompositeRenderer(WorldRenderingPipeline worldRenderingPipeline, PackDirectives packDirectives, ProgramSource[] programSourceArray, ComputeSource[][] computeSourceArray, RenderTargets renderTargets, TextureAccess textureAccess, FrameUpdateNotifier frameUpdateNotifier, CenterDepthSampler centerDepthSampler, BufferFlipper bufferFlipper, Supplier<ShadowRenderTargets> supplier, TextureStage textureStage, Object2ObjectMap<String, TextureAccess> object2ObjectMap, Object2ObjectMap<String, TextureAccess> object2ObjectMap2, Set<GlImage> set, ImmutableMap<Integer, Boolean> immutableMap, CustomUniforms customUniforms) {
        this.pipeline = worldRenderingPipeline;
        this.noiseTexture = textureAccess;
        this.updateNotifier = frameUpdateNotifier;
        this.centerDepthSampler = centerDepthSampler;
        this.renderTargets = renderTargets;
        this.customTextureIds = object2ObjectMap;
        this.customUniforms = customUniforms;
        this.irisCustomTextures = object2ObjectMap2;
        this.customImages = set;
        this.textureStage = textureStage;
        PackRenderTargetDirectives packRenderTargetDirectives = packDirectives.getRenderTargetDirectives();
        Map<Integer, PackRenderTargetDirectives.RenderTargetSettings> map = packRenderTargetDirectives.getRenderTargetSettings();
        ImmutableList.Builder builder = ImmutableList.builder();
        ImmutableSet.Builder builder2 = new ImmutableSet.Builder();
        immutableMap.forEach((n, bl) -> {
            if (bl.booleanValue()) {
                bufferFlipper.flip((int)n);
            }
        });
        for (int i = 0; i < programSourceArray.length; ++i) {
            Pass pass;
            ProgramSource programSource = programSourceArray[i];
            ImmutableSet<Integer> immutableSet = bufferFlipper.snapshot();
            ImmutableSet immutableSet2 = builder2.build();
            if (programSource == null || !programSource.isValid()) {
                if (computeSourceArray[i] == null) continue;
                pass = new ComputeOnlyPass();
                ((ComputeOnlyPass)pass).computes = this.createComputes(computeSourceArray[i], immutableSet, (ImmutableSet<Integer>)immutableSet2, supplier);
                builder.add((Object)pass);
                continue;
            }
            pass = new Pass();
            ProgramDirectives programDirectives = programSource.getDirectives();
            pass.program = this.createProgram(programSource, immutableSet, (ImmutableSet<Integer>)immutableSet2, supplier);
            pass.blendModeOverride = programSource.getDirectives().getBlendModeOverride().orElse(null);
            pass.computes = this.createComputes(computeSourceArray[i], immutableSet, (ImmutableSet<Integer>)immutableSet2, supplier);
            int[] nArray = programDirectives.getDrawBuffers();
            int n2 = 0;
            int n3 = 0;
            ImmutableMap<Integer, Boolean> immutableMap2 = programDirectives.getExplicitFlips();
            GlFramebuffer glFramebuffer = renderTargets.createColorFramebuffer(immutableSet, nArray);
            for (int n4 : nArray) {
                RenderTarget renderTarget = renderTargets.get(n4);
                if (n2 > 0 && n2 != renderTarget.getWidth() || n3 > 0 && n3 != renderTarget.getHeight()) {
                    throw new IllegalStateException("Pass sizes must match for drawbuffers " + Arrays.toString(nArray) + "\nOriginal width: " + n2 + " New width: " + renderTarget.getWidth() + " Original height: " + n3 + " New height: " + renderTarget.getHeight());
                }
                n2 = renderTarget.getWidth();
                n3 = renderTarget.getHeight();
                if (immutableMap2.get((Object)n4) == Boolean.FALSE) continue;
                bufferFlipper.flip(n4);
                builder2.add((Object)n4);
            }
            immutableMap2.forEach((n, bl) -> {
                if (bl.booleanValue()) {
                    bufferFlipper.flip((int)n);
                    builder2.add(n);
                }
            });
            pass.drawBuffers = programDirectives.getDrawBuffers();
            pass.viewWidth = n2;
            pass.viewHeight = n3;
            pass.stageReadsFromAlt = immutableSet;
            pass.framebuffer = glFramebuffer;
            pass.viewportScale = programDirectives.getViewportScale();
            pass.mipmappedBuffers = programDirectives.getMipmappedBuffers();
            pass.flippedAtLeastOnce = immutableSet2;
            builder.add((Object)pass);
        }
        this.passes = builder.build();
        this.flippedAtLeastOnceFinal = builder2.build();
        GlStateManager._glBindFramebuffer((int)36008, (int)0);
    }

    public ImmutableSet<Integer> getFlippedAtLeastOnceFinal() {
        return this.flippedAtLeastOnceFinal;
    }

    public void recalculateSizes() {
        for (Pass pass : this.passes) {
            if (pass instanceof ComputeOnlyPass) continue;
            int n = 0;
            int n2 = 0;
            for (int n3 : pass.drawBuffers) {
                RenderTarget renderTarget = this.renderTargets.get(n3);
                if (n > 0 && n != renderTarget.getWidth() || n2 > 0 && n2 != renderTarget.getHeight()) {
                    throw new IllegalStateException("Pass widths must match");
                }
                n = renderTarget.getWidth();
                n2 = renderTarget.getHeight();
            }
            this.renderTargets.destroyFramebuffer(pass.framebuffer);
            pass.framebuffer = this.renderTargets.createColorFramebuffer(pass.stageReadsFromAlt, pass.drawBuffers);
            pass.viewWidth = n;
            pass.viewHeight = n2;
        }
    }

    public void renderAll() {
        RenderSystem.disableBlend();
        FullScreenQuadRenderer.INSTANCE.begin();
        class_276 class_2762 = class_310.method_1551().method_1522();
        for (Pass pass : this.passes) {
            boolean bl = false;
            for (ComputeProgram computeProgram : pass.computes) {
                if (computeProgram == null) continue;
                bl = true;
                computeProgram.use();
                this.customUniforms.push(computeProgram);
                computeProgram.dispatch(class_2762.field_1482, class_2762.field_1481);
            }
            if (bl) {
                IrisRenderSystem.memoryBarrier(8232);
            }
            Program.unbind();
            if (pass instanceof ComputeOnlyPass) continue;
            if (!pass.mipmappedBuffers.isEmpty()) {
                RenderSystem.activeTexture((int)33984);
                UnmodifiableIterator unmodifiableIterator = pass.mipmappedBuffers.iterator();
                while (unmodifiableIterator.hasNext()) {
                    int n = (Integer)unmodifiableIterator.next();
                    CompositeRenderer.setupMipmapping(this.renderTargets.get(n), pass.stageReadsFromAlt.contains((Object)n));
                }
            }
            float f = (float)pass.viewWidth * pass.viewportScale;
            float f2 = (float)pass.viewHeight * pass.viewportScale;
            RenderSystem.viewport((int)0, (int)0, (int)((int)f), (int)((int)f2));
            pass.framebuffer.bind();
            pass.program.use();
            if (pass.blendModeOverride != null) {
                pass.blendModeOverride.apply();
            } else {
                RenderSystem.disableBlend();
            }
            this.customUniforms.push(pass.program);
            FullScreenQuadRenderer.INSTANCE.renderQuad();
            BlendModeOverride.restore();
        }
        FullScreenQuadRenderer.INSTANCE.end();
        class_310.method_1551().method_1522().method_1235(true);
        ProgramUniforms.clearActiveUniforms();
        ProgramSamplers.clearActiveSamplers();
        GlStateManager._glUseProgram((int)0);
        for (int i = 0; i < SamplerLimits.get().getMaxTextureUnits(); ++i) {
            RenderSystem.activeTexture((int)(33984 + i));
            RenderSystem.bindTexture((int)0);
        }
        RenderSystem.activeTexture((int)33984);
    }

    private static void setupMipmapping(RenderTarget renderTarget, boolean bl) {
        if (renderTarget == null) {
            return;
        }
        int n = bl ? renderTarget.getAltTexture() : renderTarget.getMainTexture();
        IrisRenderSystem.generateMipmaps(n, 3553);
        int n2 = 9987;
        if (renderTarget.getInternalFormat().getPixelFormat().isInteger()) {
            n2 = 9984;
        }
        IrisRenderSystem.texParameteri(n, 3553, 10241, n2);
    }

    private Program createProgram(ProgramSource programSource, ImmutableSet<Integer> immutableSet, ImmutableSet<Integer> immutableSet2, Supplier<ShadowRenderTargets> supplier) {
        ProgramBuilder programBuilder;
        Map<PatchShaderType, String> map = TransformPatcher.patchComposite(programSource.getName(), programSource.getVertexSource().orElseThrow(NullPointerException::new), programSource.getGeometrySource().orElse(null), programSource.getFragmentSource().orElseThrow(NullPointerException::new), this.textureStage, this.pipeline.getTextureMap());
        String string = map.get((Object)PatchShaderType.VERTEX);
        String string2 = map.get((Object)PatchShaderType.GEOMETRY);
        String string3 = map.get((Object)PatchShaderType.FRAGMENT);
        ShaderPrinter.printProgram(programSource.getName()).addSources(map).print();
        Objects.requireNonNull(immutableSet);
        try {
            programBuilder = ProgramBuilder.begin(programSource.getName(), string, string2, string3, IrisSamplers.COMPOSITE_RESERVED_TEXTURE_UNITS);
        }
        catch (ShaderCompileException shaderCompileException) {
            throw shaderCompileException;
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeException("Shader compilation failed for " + programSource.getName() + "!", runtimeException);
        }
        CommonUniforms.addDynamicUniforms(programBuilder, FogMode.OFF);
        this.customUniforms.assignTo(programBuilder);
        ProgramSamplers.CustomTextureSamplerInterceptor customTextureSamplerInterceptor = ProgramSamplers.customTextureSamplerInterceptor(programBuilder, this.customTextureIds, immutableSet2);
        IrisSamplers.addRenderTargetSamplers(customTextureSamplerInterceptor, () -> immutableSet, this.renderTargets, true);
        IrisSamplers.addCustomTextures(programBuilder, this.irisCustomTextures);
        IrisSamplers.addCustomImages(customTextureSamplerInterceptor, this.customImages);
        IrisImages.addRenderTargetImages(programBuilder, () -> immutableSet, this.renderTargets);
        IrisImages.addCustomImages(programBuilder, this.customImages);
        IrisSamplers.addNoiseSampler(customTextureSamplerInterceptor, this.noiseTexture);
        IrisSamplers.addCompositeSamplers(customTextureSamplerInterceptor, this.renderTargets);
        if (IrisSamplers.hasShadowSamplers(customTextureSamplerInterceptor)) {
            IrisSamplers.addShadowSamplers(customTextureSamplerInterceptor, supplier.get(), null, this.pipeline.hasFeature(FeatureFlags.SEPARATE_HARDWARE_SAMPLERS));
            IrisImages.addShadowColorImages(programBuilder, supplier.get(), null);
        }
        this.centerDepthSampler.setUsage(programBuilder.addDynamicSampler(this.centerDepthSampler::getCenterDepthTexture, "iris_centerDepthSmooth"));
        Program program = programBuilder.build();
        this.customUniforms.mapholderToPass(programBuilder, program);
        return program;
    }

    private ComputeProgram[] createComputes(ComputeSource[] computeSourceArray, ImmutableSet<Integer> immutableSet, ImmutableSet<Integer> immutableSet2, Supplier<ShadowRenderTargets> supplier) {
        ComputeProgram[] computeProgramArray = new ComputeProgram[computeSourceArray.length];
        for (int i = 0; i < computeProgramArray.length; ++i) {
            ProgramBuilder programBuilder;
            Object object;
            ComputeSource computeSource = computeSourceArray[i];
            if (computeSource == null || !computeSource.getSource().isPresent()) continue;
            Objects.requireNonNull(immutableSet);
            try {
                object = TransformPatcher.patchCompute(computeSource.getName(), computeSource.getSource().orElse(null), this.textureStage, this.pipeline.getTextureMap());
                ShaderPrinter.printProgram(computeSource.getName()).addSource(PatchShaderType.COMPUTE, (String)object).print();
                programBuilder = ProgramBuilder.beginCompute(computeSource.getName(), (String)object, IrisSamplers.COMPOSITE_RESERVED_TEXTURE_UNITS);
            }
            catch (ShaderCompileException shaderCompileException) {
                throw shaderCompileException;
            }
            catch (RuntimeException runtimeException) {
                throw new RuntimeException("Shader compilation failed for compute " + computeSource.getName() + "!", runtimeException);
            }
            object = ProgramSamplers.customTextureSamplerInterceptor(programBuilder, this.customTextureIds, immutableSet2);
            CommonUniforms.addDynamicUniforms(programBuilder, FogMode.OFF);
            this.customUniforms.assignTo(programBuilder);
            IrisSamplers.addRenderTargetSamplers((SamplerHolder)object, () -> immutableSet, this.renderTargets, true);
            IrisSamplers.addCustomTextures(programBuilder, this.irisCustomTextures);
            IrisSamplers.addCustomImages((SamplerHolder)object, this.customImages);
            IrisImages.addRenderTargetImages(programBuilder, () -> immutableSet, this.renderTargets);
            IrisImages.addCustomImages(programBuilder, this.customImages);
            IrisSamplers.addNoiseSampler((SamplerHolder)object, this.noiseTexture);
            IrisSamplers.addCompositeSamplers((SamplerHolder)object, this.renderTargets);
            if (IrisSamplers.hasShadowSamplers((SamplerHolder)object)) {
                IrisSamplers.addShadowSamplers((SamplerHolder)object, supplier.get(), null, this.pipeline.hasFeature(FeatureFlags.SEPARATE_HARDWARE_SAMPLERS));
                IrisImages.addShadowColorImages(programBuilder, supplier.get(), null);
            }
            this.centerDepthSampler.setUsage(programBuilder.addDynamicSampler(this.centerDepthSampler::getCenterDepthTexture, "iris_centerDepthSmooth"));
            computeProgramArray[i] = programBuilder.buildCompute();
            this.customUniforms.mapholderToPass(programBuilder, computeProgramArray[i]);
            computeProgramArray[i].setWorkGroupInfo(computeSource.getWorkGroupRelative(), computeSource.getWorkGroups());
        }
        return computeProgramArray;
    }

    public void destroy() {
        for (Pass pass : this.passes) {
            pass.destroy();
        }
    }

    private class ComputeOnlyPass
    extends Pass {
        private ComputeOnlyPass() {
        }

        @Override
        protected void destroy() {
            for (ComputeProgram computeProgram : this.computes) {
                if (computeProgram == null) continue;
                computeProgram.destroy();
            }
        }
    }

    private static class Pass {
        int[] drawBuffers;
        int viewWidth;
        int viewHeight;
        Program program;
        BlendModeOverride blendModeOverride;
        ComputeProgram[] computes;
        GlFramebuffer framebuffer;
        ImmutableSet<Integer> flippedAtLeastOnce;
        ImmutableSet<Integer> stageReadsFromAlt;
        ImmutableSet<Integer> mipmappedBuffers;
        float viewportScale;

        private Pass() {
        }

        protected void destroy() {
            this.program.destroy();
            for (ComputeProgram computeProgram : this.computes) {
                if (computeProgram == null) continue;
                computeProgram.destroy();
            }
        }
    }
}

