/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import java.util.Optional;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.ProgramDirectives;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ShaderProperties;

public class ProgramSource {
    private final String name;
    private final String vertexSource;
    private final String geometrySource;
    private final String fragmentSource;
    private final ProgramDirectives directives;
    private final ProgramSet parent;

    private ProgramSource(String string, String string2, String string3, String string4, ProgramDirectives programDirectives, ProgramSet programSet) {
        this.name = string;
        this.vertexSource = string2;
        this.geometrySource = string3;
        this.fragmentSource = string4;
        this.directives = programDirectives;
        this.parent = programSet;
    }

    public ProgramSource(String string, String string2, String string3, String string4, ProgramSet programSet, ShaderProperties shaderProperties, BlendModeOverride blendModeOverride) {
        this.name = string;
        this.vertexSource = string2;
        this.geometrySource = string3;
        this.fragmentSource = string4;
        this.parent = programSet;
        this.directives = new ProgramDirectives(this, shaderProperties, PackRenderTargetDirectives.BASELINE_SUPPORTED_RENDER_TARGETS, blendModeOverride);
    }

    public ProgramSource withDirectiveOverride(ProgramDirectives programDirectives) {
        return new ProgramSource(this.name, this.vertexSource, this.geometrySource, this.fragmentSource, programDirectives, this.parent);
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getVertexSource() {
        return Optional.ofNullable(this.vertexSource);
    }

    public Optional<String> getGeometrySource() {
        return Optional.ofNullable(this.geometrySource);
    }

    public Optional<String> getFragmentSource() {
        return Optional.ofNullable(this.fragmentSource);
    }

    public ProgramDirectives getDirectives() {
        return this.directives;
    }

    public ProgramSet getParent() {
        return this.parent;
    }

    public boolean isValid() {
        return this.vertexSource != null && this.fragmentSource != null;
    }

    public Optional<ProgramSource> requireValid() {
        if (this.isValid()) {
            return Optional.of(this);
        }
        return Optional.empty();
    }
}

