/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.materialmap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.coderbot.iris.Iris;
import net.coderbot.iris.shaderpack.materialmap.NamespacedId;
import org.jetbrains.annotations.NotNull;

public class BlockEntry {
    private final NamespacedId id;
    private final Map<String, String> propertyPredicates;

    public BlockEntry(NamespacedId namespacedId, Map<String, String> map) {
        this.id = namespacedId;
        this.propertyPredicates = map;
    }

    @NotNull
    public static BlockEntry parse(@NotNull String string) {
        NamespacedId namespacedId;
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Called BlockEntry::parse with an empty string");
        }
        String[] stringArray = string.split(":");
        if (stringArray.length == 1) {
            return new BlockEntry(new NamespacedId("minecraft", string), Collections.emptyMap());
        }
        if (stringArray.length == 2 && !stringArray[1].contains("=")) {
            return new BlockEntry(new NamespacedId(stringArray[0], stringArray[1]), Collections.emptyMap());
        }
        if (stringArray[1].contains("=")) {
            var2_2 = 1;
            namespacedId = new NamespacedId("minecraft", stringArray[0]);
        } else {
            var2_2 = 2;
            namespacedId = new NamespacedId(stringArray[0], stringArray[1]);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = var2_2; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("=");
            if (stringArray2.length != 2) {
                Iris.logger.warn("Warning: the block ID map entry \"" + string + "\" could not be fully parsed:");
                Iris.logger.warn("- Block state property filters must be of the form \"key=value\", but " + stringArray[i] + " is not of that form!");
                continue;
            }
            hashMap.put(stringArray2[0], stringArray2[1]);
        }
        return new BlockEntry(namespacedId, hashMap);
    }

    public NamespacedId getId() {
        return this.id;
    }

    public Map<String, String> getPropertyPredicates() {
        return this.propertyPredicates;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BlockEntry blockEntry = (BlockEntry)object;
        return Objects.equals(this.id, blockEntry.id) && Objects.equals(this.propertyPredicates, blockEntry.propertyPredicates);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.propertyPredicates);
    }
}

