/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.option.menu;

import com.google.common.collect.ImmutableMap;
import net.coderbot.iris.shaderpack.ShaderProperties;
import net.coderbot.iris.shaderpack.option.MergedBooleanOption;
import net.coderbot.iris.shaderpack.option.MergedStringOption;
import net.coderbot.iris.shaderpack.option.ShaderPackOptions;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuBooleanOptionElement;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuContainer;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuLinkElement;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuProfileElement;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuStringOptionElement;

public abstract class OptionMenuElement {
    public static final OptionMenuElement EMPTY;
    private static final String ELEMENT_EMPTY = "<empty>";
    private static final String ELEMENT_PROFILE = "<profile>";

    public static OptionMenuElement create(String string, OptionMenuContainer optionMenuContainer, ShaderProperties shaderProperties, ShaderPackOptions shaderPackOptions) throws IllegalArgumentException {
        if (ELEMENT_EMPTY.equals(string)) {
            return EMPTY;
        }
        if (ELEMENT_PROFILE.equals(string)) {
            return optionMenuContainer.getProfiles().size() > 0 ? new OptionMenuProfileElement(optionMenuContainer.getProfiles(), shaderPackOptions.getOptionSet(), shaderPackOptions.getOptionValues()) : null;
        }
        if (string.startsWith("[") && string.endsWith("]")) {
            return new OptionMenuLinkElement(string.substring(1, string.length() - 1));
        }
        ImmutableMap<String, MergedBooleanOption> immutableMap = shaderPackOptions.getOptionSet().getBooleanOptions();
        ImmutableMap<String, MergedStringOption> immutableMap2 = shaderPackOptions.getOptionSet().getStringOptions();
        if (immutableMap.containsKey(string)) {
            return new OptionMenuBooleanOptionElement(string, optionMenuContainer, shaderProperties, shaderPackOptions.getOptionValues(), ((MergedBooleanOption)immutableMap.get(string)).getOption());
        }
        if (immutableMap2.containsKey(string)) {
            return new OptionMenuStringOptionElement(string, optionMenuContainer, shaderProperties, shaderPackOptions.getOptionValues(), ((MergedStringOption)immutableMap2.get(string)).getOption());
        }
        throw new IllegalArgumentException("Unable to resolve shader pack option menu element \"" + string + "\" defined in shaders.properties");
    }

    static {
        class Net_coderbot_iris_shaderpack_option_menu_OptionMenuElement$1
        extends OptionMenuElement {
            Net_coderbot_iris_shaderpack_option_menu_OptionMenuElement$1() {
            }
        }
        EMPTY = new Net_coderbot_iris_shaderpack_option_menu_OptionMenuElement$1();
    }
}

