/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms.custom.cached;

import kroppeb.stareval.expression.Expression;
import kroppeb.stareval.expression.VariableExpression;
import kroppeb.stareval.function.FunctionContext;
import kroppeb.stareval.function.FunctionReturn;
import kroppeb.stareval.function.Type;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.parsing.VectorType;
import net.coderbot.iris.uniforms.custom.cached.BooleanCachedUniform;
import net.coderbot.iris.uniforms.custom.cached.Float2VectorCachedUniform;
import net.coderbot.iris.uniforms.custom.cached.Float3VectorCachedUniform;
import net.coderbot.iris.uniforms.custom.cached.Float4VectorCachedUniform;
import net.coderbot.iris.uniforms.custom.cached.FloatCachedUniform;
import net.coderbot.iris.uniforms.custom.cached.IntCachedUniform;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector4f;

public abstract class CachedUniform
implements VariableExpression {
    private final String name;
    private final UniformUpdateFrequency updateFrequency;
    private boolean changed = true;

    public CachedUniform(String string, UniformUpdateFrequency uniformUpdateFrequency) {
        this.name = string;
        this.updateFrequency = uniformUpdateFrequency;
    }

    public void markUnchanged() {
        this.changed = false;
    }

    public void update() {
        this.doUpdate();
        this.changed = true;
    }

    protected abstract boolean doUpdate();

    public abstract void push(int var1);

    public void pushIfChanged(int n) {
        if (this.changed) {
            this.push(n);
        }
    }

    @Override
    public void evaluateTo(FunctionContext functionContext, FunctionReturn functionReturn) {
        this.writeTo(functionReturn);
    }

    public abstract void writeTo(FunctionReturn var1);

    public abstract Type getType();

    public static CachedUniform forExpression(String string, Type type, Expression expression, FunctionContext functionContext) {
        FunctionReturn functionReturn = new FunctionReturn();
        UniformUpdateFrequency uniformUpdateFrequency = UniformUpdateFrequency.CUSTOM;
        if (type.equals(Type.Boolean)) {
            return new BooleanCachedUniform(string, uniformUpdateFrequency, () -> {
                expression.evaluateTo(functionContext, functionReturn);
                return functionReturn.booleanReturn;
            });
        }
        if (type.equals(Type.Int)) {
            return new IntCachedUniform(string, uniformUpdateFrequency, () -> {
                expression.evaluateTo(functionContext, functionReturn);
                return functionReturn.intReturn;
            });
        }
        if (type.equals(Type.Float)) {
            return new FloatCachedUniform(string, uniformUpdateFrequency, () -> {
                expression.evaluateTo(functionContext, functionReturn);
                return functionReturn.floatReturn;
            });
        }
        if (type.equals(VectorType.VEC2)) {
            return new Float2VectorCachedUniform(string, uniformUpdateFrequency, () -> {
                expression.evaluateTo(functionContext, functionReturn);
                return (Vector2f)functionReturn.objectReturn;
            });
        }
        if (type.equals(VectorType.VEC3)) {
            return new Float3VectorCachedUniform(string, uniformUpdateFrequency, () -> {
                expression.evaluateTo(functionContext, functionReturn);
                return (Vector3f)functionReturn.objectReturn;
            });
        }
        if (type.equals(VectorType.VEC4)) {
            return new Float4VectorCachedUniform(string, uniformUpdateFrequency, () -> {
                expression.evaluateTo(functionContext, functionReturn);
                return (Vector4f)functionReturn.objectReturn;
            });
        }
        throw new IllegalArgumentException("Custom uniforms of type: " + type + " are currently not supported");
    }

    public String getName() {
        return this.name;
    }

    public UniformUpdateFrequency getUpdateFrequency() {
        return this.updateFrequency;
    }
}

