/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ca extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ae = "av\u00e8stic";
        final String metaValue_ar = "\u00e0rab";
        final String metaValue_bn = "bengal\u00ed";
        final String metaValue_bo = "tibet\u00e0";
        final String metaValue_el = "grec";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "hebreu";
        final String metaValue_hy = "armeni";
        final String metaValue_ja = "japon\u00e8s";
        final String metaValue_jv = "javan\u00e8s";
        final String metaValue_ka = "georgi\u00e0";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "core\u00e0";
        final String metaValue_la = "llat\u00ed";
        final String metaValue_ml = "malai\u00e0lam";
        final String metaValue_mn = "mongol";
        final String metaValue_my = "birm\u00e0";
        final String metaValue_or = "oriya";
        final String metaValue_si = "singal\u00e8s";
        final String metaValue_ta = "t\u00e0mil";
        final String metaValue_te = "telugu";
        final String metaValue_ban = "balin\u00e8s";
        final String metaValue_bax = "bamum";
        final String metaValue_ccp = "chakma";
        final String metaValue_chr = "cherokee";
        final String metaValue_cop = "copte";
        final String metaValue_got = "g\u00f2tic";
        final String metaValue_kpe = "kpelle";
        final String metaValue_men = "mende";
        final String metaValue_mni = "manipur\u00ed";
        final String metaValue_nqo = "n\u2019Ko";
        final String metaValue_osa = "osage";
        final String metaValue_pal = "pahlavi";
        final String metaValue_peo = "persa antic";
        final String metaValue_phn = "fenici";
        final String metaValue_sat = "santali";
        final String metaValue_ssy = "saho";
        final String metaValue_syr = "sir\u00edac";
        final String metaValue_uga = "ugar\u00edtic";
        final String metaValue_vai = "vai";
        final String metaValue_zbl = "s\u00edmbols Bliss";
        final Object[][] data = new Object[][] {
            { "ksh", "k\u00f6lsch" },
            { "Ogam", "ogham" },
            { "mwl", "mirand\u00e8s" },
            { "Zsym", "s\u00edmbols" },
            { "cch", "atsam" },
            { "mwr", "marwari" },
            { "type.nu.lanatham", "d\u00edgits tai tham tham" },
            { "egl", "emili\u00e0" },
            { "Tagb", "tagbanwa" },
            { "Zsye", "emoji" },
            { "%%NJIVA", "dialecte de Gniva/Njiva" },
            { "xmf", "mingreli\u00e0" },
            { "ccp", metaValue_ccp },
            { "egy", "egipci antic" },
            { "raj", "rajasthani" },
            { "Phag", "phagspa" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "ter", "terena" },
            { "AC", "Illa de l\u2019Ascensi\u00f3" },
            { "rar", "rarotong\u00e0" },
            { "tet", "t\u00e8tum" },
            { "AD", "Andorra" },
            { "AE", "Emirats \u00c0rabs Units" },
            { "nl_BE", "flamenc" },
            { "AF", "Afganistan" },
            { "AG", "Antigua i Barbuda" },
            { "type.ca.ethiopic", "calendari et\u00edop" },
            { "glk", "gilaki" },
            { "AI", "Anguilla" },
            { "key.tz", "zona hor\u00e0ria" },
            { "AL", "Alb\u00e0nia" },
            { "AM", "Arm\u00e8nia" },
            { "Teng", "tengwar" },
            { "AO", "Angola" },
            { "AQ", "Ant\u00e0rtida" },
            { "AR", "Argentina" },
            { "Prti", "parthi\u00e0 inscripcional" },
            { "AS", "Samoa Nord-americana" },
            { "AT", "\u00c0ustria" },
            { "AU", "Austr\u00e0lia" },
            { "AW", "Aruba" },
            { "en_US", "angl\u00e8s americ\u00e0" },
            { "AX", "Illes \u00c5land" },
            { "mye", "myene" },
            { "AZ", "Azerbaidjan" },
            { "%%AREVELA", "armeni oriental" },
            { "BA", "B\u00f2snia i Hercegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebu\u00e0" },
            { "BD", "Bangladesh" },
            { "kum", "k\u00famik" },
            { "BE", "B\u00e8lgica" },
            { "gmh", "alt alemany mitj\u00e0" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulg\u00e0ria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Ben\u00edn" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermudes" },
            { "kut", "kutenai" },
            { "myv", "mordovi\u00e0 erza" },
            { "BN", "Brunei" },
            { "BO", "Bol\u00edvia" },
            { "BQ", "Carib Neerland\u00e8s" },
            { "BR", "Brasil" },
            { "BS", "Bahames" },
            { "xog", "soga" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Belar\u00fas" },
            { "BZ", "Belize" },
            { "Visp", "llenguatge visible" },
            { "type.ca.persian", "calendari persa" },
            { "type.nu.hebr", "nombres hebreus" },
            { "CA", "Canad\u00e0" },
            { "CC", "Illes Cocos" },
            { "mzn", "mazanderani" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Rep\u00fablica Centreafricana" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Su\u00efssa" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Illes Cook" },
            { "CL", "Xile" },
            { "Kthi", "kaithi" },
            { "CM", "Camerun" },
            { "CN", "Xina" },
            { "CO", "Col\u00f2mbia" },
            { "CP", "Illa Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cap Verd" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Illa Christmas" },
            { "CY", "Xipre" },
            { "type.nu.bali", "d\u00edgits balinesos" },
            { "CZ", "Tx\u00e8quia" },
            { "eka", "ekajuk" },
            { "Ahom", "ahom" },
            { "Pauc", "Pau Cin Hau" },
            { "vls", "flamenc occidental" },
            { "DE", "Alemanya" },
            { "goh", "alt alemany antic" },
            { "ace", "atjeh" },
            { "cgg", "chiga" },
            { "DG", "Diego Garcia" },
            { "gom", "concani de Goa" },
            { "type.nu.deva", "d\u00edgits devanagaris" },
            { "DJ", "Djibouti" },
            { "DK", "Dinamarca" },
            { "ach", "acoli" },
            { "gon", "gondi" },
            { "Brai", "braille" },
            { "Brah", "brahmi" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "nombres armenis en min\u00fascula" },
            { "DO", "Rep\u00fablica Dominicana" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "Mtei", metaValue_mni },
            { "zun", "zuni" },
            { "tig", "tigre" },
            { "Takr", "takri" },
            { "DZ", "Alg\u00e8ria" },
            { "pag", "pangasinan" },
            { "type.d0.hwidth", "amplada mitjana" },
            { "pal", metaValue_pal },
            { "EA", "Ceuta i Melilla" },
            { "chb", "txibtxa" },
            { "pam", "pampanga" },
            { "EC", "Equador" },
            { "pap", "papiament" },
            { "ada", "adangme" },
            { "EE", "Est\u00f2nia" },
            { "tiv", "tiv" },
            { "EG", "Egipte" },
            { "EH", "S\u00e0hara Occidental" },
            { "chg", "txagatai" },
            { "pau", "palau\u00e0" },
            { "chk", "chuuk" },
            { "chn", "pidgin chinook" },
            { "chm", "mari" },
            { "chp", "chipewyan" },
            { "cho", "choctaw" },
            { "chr", metaValue_chr },
            { "ER", "Eritrea" },
            { "ES", "Espanya" },
            { "ET", "Eti\u00f2pia" },
            { "EU", "Uni\u00f3 Europea" },
            { "elx", "elamita" },
            { "type.ca.gregorian", "calendari gregori\u00e0" },
            { "EZ", "zona euro" },
            { "chy", "xeiene" },
            { "type.nu.gujr", "d\u00edgits gujarati" },
            { "Inds", "escriptura de la vall de l\u2019Indus" },
            { "ady", "adigu\u00e9" },
            { "FI", "Finl\u00e0ndia" },
            { "FJ", "Fiji" },
            { "FK", "Illes Malvines" },
            { "FM", "Micron\u00e8sia" },
            { "key.va", "variant local" },
            { "FO", "Illes F\u00e8roe" },
            { "Taml", metaValue_ta },
            { "FR", "Fran\u00e7a" },
            { "Kpel", metaValue_kpe },
            { "pcd", "picard" },
            { "tkl", "tokelau\u00e8s" },
            { "grb", "grebo" },
            { "type.ca.indian", "calendari hind\u00fa" },
            { "rgn", "romany\u00e8s" },
            { "grc", "grec antic" },
            { "GA", "Gabon" },
            { "tkr", "tsakhur" },
            { "vot", "v\u00f2tic" },
            { "GB", "Regne Unit" },
            { "pcm", "pidgin de Nig\u00e8ria" },
            { "GD", "Grenada" },
            { "GE", "Ge\u00f2rgia" },
            { "GF", "Guaiana Francesa" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "tai le" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Groenl\u00e0ndia" },
            { "enm", "angl\u00e8s mitj\u00e0" },
            { "GM", "G\u00e0mbia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupe" },
            { "GQ", "Guinea Equatorial" },
            { "GR", "Gr\u00e8cia" },
            { "GS", "Illes Ge\u00f2rgia del Sud i Sandwich del Sud" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "alemany pennsilvani\u00e0" },
            { "GW", "Guinea Bissau" },
            { "tli", "tlingit" },
            { "tlh", "klingoni\u00e0" },
            { "Talu", "nou tai lue" },
            { "GY", "Guyana" },
            { "ckb", "kurd central" },
            { "zxx", "sense contingut ling\u00fc\u00edstic" },
            { "Jurc", "j\u00fcrchen" },
            { "tly", "talix" },
            { "de_AT", "alemany austr\u00edac" },
            { "Vaii", metaValue_vai },
            { "HK", "Hong Kong (RAE Xina)" },
            { "HM", "Illa Heard i Illes McDonald" },
            { "HN", "Hondures" },
            { "HR", "Cro\u00e0cia" },
            { "agq", "aghem" },
            { "gsw", "alemany su\u00eds" },
            { "type.ca.islamic-umalqura", "calendari isl\u00e0mic (Umm al-Qura)" },
            { "HT", "Hait\u00ed" },
            { "HU", "Hongria" },
            { "tmh", "amazic" },
            { "IC", "Illes Can\u00e0ries" },
            { "nan", "xin\u00e8s min del sud" },
            { "peo", metaValue_peo },
            { "ID", "Indon\u00e8sia" },
            { "Adlm", "adlam" },
            { "type.nu.kali", "d\u00edgits kayah" },
            { "IE", "Irlanda" },
            { "nap", "napolit\u00e0" },
            { "%%NDYUKA", "dialecte ndyuka" },
            { "naq", "nama" },
            { "zza", "zaza" },
            { "Tang", "tangut" },
            { "IL", "Israel" },
            { "Nbat", "nabateu" },
            { "IM", "Illa de Man" },
            { "IN", "\u00cdndia" },
            { "type.co.eor", "normes europees d\u2019ordenaci\u00f3" },
            { "IO", "Territori Brit\u00e0nic de l\u2019Oce\u00e0 \u00cdndic" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Isl\u00e0ndia" },
            { "IT", "It\u00e0lia" },
            { "Zmth", "notaci\u00f3 matem\u00e0tica" },
            { "type.nu.thai", "d\u00edgits tai" },
            { "guc", "way\u00fa" },
            { "%%POSIX", "ordinador" },
            { "type.nu.beng", "d\u00edgits bengalins" },
            { "pfl", "alemany palat\u00ed" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "calendari isl\u00e0mic" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaica" },
            { "JO", "Jord\u00e0nia" },
            { "JP", "Jap\u00f3" },
            { "%%1606NICT", "franc\u00e8s mitj\u00e0 tard\u00e0 fins el 1606" },
            { "ain", "ainu" },
            { "Mend", metaValue_men },
            { "guz", "gus\u00ed" },
            { "tog", "tonga" },
            { "type.nu.knda", "d\u00edgits kannada" },
            { "Kali", "kayah li" },
            { "Sidd", "siddham" },
            { "de_CH", "alemany est\u00e0ndard su\u00eds" },
            { "type.co.phonetic", "Ordenaci\u00f3 fon\u00e8tica" },
            { "type.ca.buddhist", "calendari budista" },
            { "KE", "Kenya" },
            { "419", "Am\u00e8rica Llatina" },
            { "KG", "Kirguizistan" },
            { "KH", "Cambodja" },
            { "KI", "Kiribati" },
            { "KM", "Comores" },
            { "Knda", metaValue_kn },
            { "KN", "Saint Christopher i Nevis" },
            { "Zinh", "heretat" },
            { "fr_CA", "franc\u00e8s canadenc" },
            { "KP", "Corea del Nord" },
            { "KR", "Corea del Sud" },
            { "Plrd", "pollard miao" },
            { "fr_CH", "franc\u00e8s su\u00eds" },
            { "KW", "Kuwait" },
            { "tpi", "tok pisin" },
            { "KY", "Illes Caiman" },
            { "KZ", "Kazakhstan" },
            { "Cyrl", "cir\u00edl\u00b7lic" },
            { "LA", "Laos" },
            { "LB", "L\u00edban" },
            { "phn", metaValue_phn },
            { "LC", "Saint Lucia" },
            { "Cyrs", "cir\u00edl\u00b7lic de l\u2019antic eslau eclesi\u00e0stic" },
            { "gwi", "gwich\u2019in" },
            { "%%LUNA1918", "luna 1918" },
            { "nds", "baix alemany" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "accadi" },
            { "cop", metaValue_cop },
            { "LR", "Lib\u00e8ria" },
            { "Phlv", metaValue_pal },
            { "LS", "Lesotho" },
            { "LT", "Litu\u00e0nia" },
            { "LU", "Luxemburg" },
            { "LV", "Let\u00f2nia" },
            { "Kana", "katakana" },
            { "Sora", "sora sompeng" },
            { "LY", "L\u00edbia" },
            { "lad", "judeocastell\u00e0" },
            { "vun", "vunjo" },
            { "akz", "alabama" },
            { "%%LAUKIKA", "laukika" },
            { "lah", "panjabi occidental" },
            { "Mahj", "mahajani" },
            { "lag", "langi" },
            { "Thaa", "thaana" },
            { "MA", "Marroc" },
            { "MC", "M\u00f2naco" },
            { "MD", "Mold\u00e0via" },
            { "Nshu", "n\u00fc shu" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "lam", "lamba" },
            { "MG", "Madagascar" },
            { "MH", "Illes Marshall" },
            { "ale", "aleuta" },
            { "Thai", "tailand\u00e8s" },
            { "type.nu.vaii", "d\u00edgits vai" },
            { "MK", "Maced\u00f2nia del Nord" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birm\u00e0nia)" },
            { "MN", "Mong\u00f2lia" },
            { "new", "newari" },
            { "MO", "Macau (RAE Xina)" },
            { "aln", "alban\u00e8s geg" },
            { "MP", "Illes Mariannes del Nord" },
            { "MQ", "Martinica" },
            { "MR", "Maurit\u00e0nia" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "type.m0.ungegn", "sistema de transliteraci\u00f3 UNGEGN" },
            { "MU", "Maurici" },
            { "alt", "altaic meridional" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "M\u00e8xic" },
            { "type.ca.japanese", "calendari japon\u00e8s" },
            { "MY", "Mal\u00e0isia" },
            { "MZ", "Mo\u00e7ambic" },
            { "Phli", "pahlavi inscripcional" },
            { "NA", "Nam\u00edbia" },
            { "202", "\u00c0frica subsahariana" },
            { "type.ca.hebrew", "calendari hebreu" },
            { "type.co.dictionary", "ordenaci\u00f3 de diccionari" },
            { "NC", "Nova Caled\u00f2nia" },
            { "%%WADEGILE", "romanitzaci\u00f3 Wade-Giles" },
            { "%%UCRCOR", "ortografia revisada unificada" },
            { "NE", "N\u00edger" },
            { "NF", "Norfolk" },
            { "NG", "Nig\u00e8ria" },
            { "trv", "taroko" },
            { "Phlp", "psalter pahlavi" },
            { "NI", "Nicaragua" },
            { "Hmng", "pahawh hmong" },
            { "NL", "Pa\u00efsos Baixos" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "tsi", "tsimshi\u00e0" },
            { "NZ", "Nova Zelanda" },
            { "Merc", "cursiva mero\u00edtica" },
            { "rom", "roman\u00ed" },
            { "Mero", "mero\u00edtic" },
            { "crh", "t\u00e0tar de Crimea" },
            { "ang", "angl\u00e8s antic" },
            { "OM", "Oman" },
            { "%%PETR1708", "ortografia russa 1708\u20131917" },
            { "anp", "angika" },
            { "crs", "franc\u00e8s crioll de les Seychelles" },
            { "Xpeo", metaValue_peo },
            { "PA", "Panam\u00e0" },
            { "type.ca.islamic-civil", "calendari civil isl\u00e0mic" },
            { "csb", "caixubi" },
            { "en_GB", "angl\u00e8s brit\u00e0nic" },
            { "PE", "Per\u00fa" },
            { "ttt", "tat meridional" },
            { "PF", "Polin\u00e8sia Francesa" },
            { "PG", "Papua Nova Guinea" },
            { "PH", "Filipines" },
            { "PK", "Pakistan" },
            { "PL", "Pol\u00f2nia" },
            { "ewo", "ewondo" },
            { "PM", "Saint-Pierre-et-Miquelon" },
            { "PN", "Illes Pitcairn" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Territoris palestins" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "type.nu.greklow", "nombres grecs en min\u00fascula" },
            { "PY", "Paraguai" },
            { "tum", "tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "angl\u00e8s est\u00e0ndard d\u2019Esc\u00f2cia" },
            { "jam", "crioll angl\u00e8s de Jamaica" },
            { "pms", "piemont\u00e8s" },
            { "niu", "niue\u00e0" },
            { "QO", "Territoris allunyats d\u2019Oceania" },
            { "ext", "extremeny" },
            { "lez", "lesgui\u00e0" },
            { "%%FONUPA", "sistema fon\u00e8tic UPA" },
            { "tvl", "tuvalu\u00e0" },
            { "Tavt", "tai viet" },
            { "001", "M\u00f3n" },
            { "002", "\u00c0frica" },
            { "003", "Am\u00e8rica del Nord" },
            { "RE", "Illa de la Reuni\u00f3" },
            { "005", "Am\u00e8rica del Sud" },
            { "jbo", "lojban" },
            { "pnt", "p\u00f2ntic" },
            { "Rjng", "rejang" },
            { "009", "Oceania" },
            { "%%SURSILV", "sobreselv\u00e0" },
            { "RO", "Romania" },
            { "RS", "S\u00e8rbia" },
            { "Mroo", "mro" },
            { "RU", "R\u00fassia" },
            { "RW", "Ruanda" },
            { "type.nu.talu", "d\u00edgits tai lue nous" },
            { "Ugar", metaValue_uga },
            { "Mani", "maniqueu" },
            { "Khar", "kharosthi" },
            { "SA", "Ar\u00e0bia Saudita" },
            { "pon", "ponape\u00e0" },
            { "Mand", "mandaic" },
            { "SB", "Illes Salom\u00f3" },
            { "twq", "tasawaq" },
            { "011", "\u00c0frica occidental" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "013", "Am\u00e8rica Central" },
            { "SE", "Su\u00e8cia" },
            { "014", "\u00c0frica oriental" },
            { "arc", "arameu" },
            { "Loma", "loma" },
            { "015", "\u00c0frica septentrional" },
            { "SG", "Singapur" },
            { "SH", "Saint Helena" },
            { "type.lb.strict", "salt de l\u00ednia estricte" },
            { "017", "\u00c0frica central" },
            { "SI", "Eslov\u00e8nia" },
            { "018", "\u00c0frica meridional" },
            { "SJ", "Svalbard i Jan Mayen" },
            { "Bamu", metaValue_bax },
            { "019", "Am\u00e8rica" },
            { "SK", "Eslov\u00e0quia" },
            { "Wole", "woleai" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Som\u00e0lia" },
            { "arn", "mapudungu" },
            { "arp", "arapaho" },
            { "type.nu.taml", "nombres tamils tradicionals" },
            { "SR", "Surinam" },
            { "aro", "araona" },
            { "SS", "Sudan del Sud" },
            { "ST", "S\u00e3o Tom\u00e9 i Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "ars", "\u00e0rab najdi" },
            { "SX", "Sint Maarten" },
            { "SY", "S\u00edria" },
            { "yao", "yao" },
            { "SZ", "eSwatini" },
            { "arw", "arauac" },
            { "arz", "\u00e0rab egipci" },
            { "yap", "yape\u00e0" },
            { "TA", "Tristan da Cunha" },
            { "asa", "pare" },
            { "type.ms.ussystem", "sistema d\u2019unitats dels EUA" },
            { "021", "Am\u00e8rica septentrional" },
            { "TC", "Illes Turks i Caicos" },
            { "yav", "yangben" },
            { "TD", "Txad" },
            { "Qaag", "zawgyi" },
            { "TF", "Territoris Australs Francesos" },
            { "ase", "llengua de signes americana" },
            { "TG", "Togo" },
            { "TH", "Tail\u00e0ndia" },
            { "TJ", "Tadjikistan" },
            { "029", "Carib" },
            { "TK", "Tokelau" },
            { "TL", "Timor Oriental" },
            { "ybb", "yemba" },
            { "type.co.searchjl", "cerca per consonant inicial del hangul" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "Boontling" },
            { "TN", "Tun\u00edsia" },
            { "TO", "Tonga" },
            { "TR", "Turquia" },
            { "TT", "Trinitat i Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "asturi\u00e0" },
            { "Orkh", "orkhon" },
            { "TZ", "Tanz\u00e0nia" },
            { "nmg", "bissio" },
            { "Zzzz", "escriptura desconeguda" },
            { "Sind", "devangari" },
            { "UA", "Ucra\u00efna" },
            { "lij", "l\u00edgur" },
            { "rup", "aroman\u00e8s" },
            { "030", "\u00c0sia oriental" },
            { "tyv", "tuvini\u00e0" },
            { "sw_CD", "suahili del Congo" },
            { "034", "\u00c0sia meridional" },
            { "hai", "haida" },
            { "035", "\u00c0sia sud-oriental" },
            { "UG", "Uganda" },
            { "hak", "xin\u00e8s hakka" },
            { "type.co.pinyin", "ordre pinyin" },
            { "039", "Europa meridional" },
            { "Sinh", metaValue_si },
            { "UM", "Illes Perif\u00e8riques Menors dels EUA" },
            { "UN", "Nacions Unides" },
            { "US", "Estats Units" },
            { "haw", "hawai\u00e0" },
            { "%%1959ACAD", "acad\u00e8mica" },
            { "type.co.gb2312han", "ordre del xin\u00e8s simplificat - GB2312" },
            { "UY", "Uruguai" },
            { "prg", "prussi\u00e0" },
            { "UZ", "Uzbekistan" },
            { "tzm", "amazic del Marroc central" },
            { "type.co.stroke", "ordre dels tra\u00e7os" },
            { "nnh", "ngiemboon" },
            { "VA", "Ciutat del Vatic\u00e0" },
            { "pro", "proven\u00e7al antic" },
            { "VC", "Saint Vincent i les Grenadines" },
            { "VE", "Vene\u00e7uela" },
            { "VG", "Illes Verges Brit\u00e0niques" },
            { "VI", "Illes Verges Nord-americanes" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "nogai" },
            { "rwk", "rwo" },
            { "non", "n\u00f2rdic antic" },
            { "053", "Austral\u00e0sia" },
            { "%%AREVMDA", "armeni occidental" },
            { "054", "Melan\u00e8sia" },
            { "WF", "Wallis i Futuna" },
            { "type.co.traditional", "ordre tradicional" },
            { "057", "Regi\u00f3 de la Micron\u00e8sia" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "nov", "novial" },
            { "type.nu.finance", "Numerals financers" },
            { "%%HEPBURN", "romanitzaci\u00f3 Hepburn" },
            { "type.co.compat", "ordenaci\u00f3 anterior, per a compatibilitat" },
            { "wae", "walser" },
            { "WS", "Samoa" },
            { "Bass", "bassa vah" },
            { "type.nu.mtei", "d\u00edgits meitei mayek" },
            { "wal", "wolaita" },
            { "was", "washo" },
            { "XA", "pseudoaccents" },
            { "war", "waray" },
            { "XB", "pseudobidi" },
            { "awa", "awadhi" },
            { "061", "Polin\u00e8sia" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "sense escriptura" },
            { "Olck", metaValue_sat },
            { "wbp", "warlpiri" },
            { "Batk", "batak" },
            { "Blis", metaValue_zbl },
            { "YE", "Iemen" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "ordenaci\u00f3 est\u00e0ndard" },
            { "lmo", "llombard" },
            { "fan", "fang" },
            { "%%ROZAJ", "resi\u00e0" },
            { "%%SUTSILV", "sotaselv\u00e0" },
            { "fat", "fanti" },
            { "Sgnw", "escriptura de signes" },
            { "YT", "Mayotte" },
            { "type.nu.cham", "d\u00edgits txams" },
            { "ZA", "Rep\u00fablica de Sud-\u00e0frica" },
            { "type.nu.sund", "d\u00edgits sudanesos" },
            { "type.lb.loose", "salt de l\u00ednia flexible" },
            { "Deva", "devanagari" },
            { "type.nu.geor", "nombres georgians" },
            { "Hira", "hiragana" },
            { "ZM", "Z\u00e0mbia" },
            { "%%PINYIN", "romanitzaci\u00f3 Pinyin" },
            { "ZW", "Zimb\u00e0bue" },
            { "ZZ", "regi\u00f3 desconeguda" },
            { "Runr", "r\u00fanic" },
            { "type.ms.metric", "sistema m\u00e8tric" },
            { "type.ca.iso8601", "calendari ISO-8601" },
            { "lol", "mongo" },
            { "nso", "sotho septentrional" },
            { "type.nu.telu", "d\u00edgits telugu" },
            { "lou", "crioll franc\u00e8s de Louisiana" },
            { "loz", "lozi" },
            { "Nkgb", "geba" },
            { "jmc", "machame" },
            { "hif", "hindi de Fiji" },
            { "type.nu.hansfin", "nombres financers xinesos simplificats" },
            { "hil", "h\u00edligaynon" },
            { "type.nu.arabext", "xifres indoar\u00e0bigues ampliades" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "type.nu.fullwide", "d\u00edgits d\u2019amplada completa" },
            { "hit", "hitita" },
            { "dar", "dargu\u00e0" },
            { "dav", "taita" },
            { "Maya", "jerogl\u00edfics maies" },
            { "lrc", "luri septentrional" },
            { "Copt", metaValue_cop },
            { "nwc", "newari cl\u00e0ssic" },
            { "udm", "udmurt" },
            { "Khmr", metaValue_km },
            { "Limb", "limbu" },
            { "sad", "sandawe" },
            { "type.nu.roman", "nombres romans" },
            { "sah", "iacut" },
            { "sam", "arameu samarit\u00e0" },
            { "Aghb", "alban\u00e8s cauc\u00e0sic" },
            { "%%SCOUSE", "scouse" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", metaValue_sat },
            { "Tfng", "tifinagh" },
            { "jpr", "judeopersa" },
            { "type.d0.npinyin", "Num\u00e8ric" },
            { "type.nu.native", "D\u00edgits natius" },
            { "sba", "ngambay" },
            { "Guru", "gurmukhi" },
            { "%%ALUKU", "dialecte aluku" },
            { "lua", "luba-lulua" },
            { "%%BISCAYAN", "basc bisca\u00ed" },
            { "type.d0.fwidth", "amplada completa" },
            { "sbp", "sangu" },
            { "lui", "luisenyo" },
            { "nyn", "nyankole" },
            { "nym", "nyamwesi" },
            { "lun", "lunda" },
            { "nyo", "nyoro" },
            { "luo", "luo" },
            { "fil", "filip\u00ed" },
            { "hmn", "hmong" },
            { "del", "delaware" },
            { "lus", "mizo" },
            { "bal", "balutxi" },
            { "den", "slavi" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "luy", "luyia" },
            { "bar", "bavar\u00e8s" },
            { "bas", "basa" },
            { "bax", metaValue_bax },
            { "jrb", "judeo\u00e0rab" },
            { "es_ES", "espanyol europeu" },
            { "nzi", "nzema" },
            { "sco", "escoc\u00e8s" },
            { "scn", "sicili\u00e0" },
            { "aa", "\u00e0far" },
            { "ab", "abkhaz" },
            { "Aran", "nastaliq" },
            { "ae", metaValue_ae },
            { "af", "afrikaans" },
            { "ak", "\u00e0kan" },
            { "bbj", "ghomala" },
            { "am", "amh\u00e0ric" },
            { "Arab", metaValue_ar },
            { "an", "aragon\u00e8s" },
            { "%%SOLBA", "dialecte de Stolvizza/Solbica" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "sil\u00b7labaris japonesos" },
            { "as", "assam\u00e8s" },
            { "sdc", "sasser\u00e8s" },
            { "Lina", "lineal A" },
            { "av", "\u00e0var" },
            { "Linb", "lineal B" },
            { "sdh", "kurd meridional" },
            { "ay", "aimara" },
            { "az", "azerbaidjan\u00e8s" },
            { "Khoj", "khoja" },
            { "%%OSOJS", "dialecte d\u2019Oseacco/Osojane" },
            { "ba", "baixkir" },
            { "type.co.unihan", "ordenaci\u00f3 per quantitat de tra\u00e7os radicals" },
            { "be", "belar\u00fas" },
            { "bg", "b\u00falgar" },
            { "bi", "bislama" },
            { "type.nu.java", "d\u00edgits javanesos" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "dogrib" },
            { "br", "bret\u00f3" },
            { "bs", "bosni\u00e0" },
            { "Bhks", "bhaiksuki" },
            { "see", "seneca" },
            { "Mymr", metaValue_my },
            { "type.nu.laoo", "d\u00edgits lao" },
            { "seh", "sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "selkup" },
            { "ca", "catal\u00e0" },
            { "ses", "songhai oriental" },
            { "ce", "txetx\u00e8" },
            { "ch", "chamorro" },
            { "%%REVISED", "ortografia revisada" },
            { "co", "cors" },
            { "Orya", metaValue_or },
            { "cr", "cree" },
            { "cs", "txec" },
            { "cu", "eslau eclesi\u00e0stic" },
            { "cv", "txuvaix" },
            { "cy", "gal\u00b7l\u00e8s" },
            { "type.nu.ethi", "nombres eti\u00f2pics" },
            { "Yiii", "yi" },
            { "da", "dan\u00e8s" },
            { "pt_PT", "portugu\u00e8s de Portugal" },
            { "de", "alemany" },
            { "type.cf.standard", "format de moneda est\u00e0ndard" },
            { "bej", "beja" },
            { "din", "dinka" },
            { "Bugi", "bugin\u00e8s" },
            { "bem", "bemba" },
            { "sga", "irland\u00e8s antic" },
            { "type.nu.mong", "d\u00edgits mongols" },
            { "dv", "divehi" },
            { "es_419", "espanyol hispanoameric\u00e0" },
            { "dz", "dzongka" },
            { "bez", "bena" },
            { "type.ca.chinese", "calendari xin\u00e8s" },
            { "lzh", "xin\u00e8s cl\u00e0ssic" },
            { "Lisu", "lisu" },
            { "dje", "zarma" },
            { "type.nu.grek", "nombres grecs" },
            { "ee", "ewe" },
            { "bfd", "bafut" },
            { "type.lb.normal", "salt de l\u00ednia normal" },
            { "ro_MD", "moldau" },
            { "el", metaValue_el },
            { "en", "angl\u00e8s" },
            { "eo", "esperanto" },
            { "bfq", "badaga" },
            { "lzz", "laz" },
            { "type.co.big5han", "ordre del xin\u00e8s tradicional - Big5" },
            { "es", "espanyol" },
            { "et", "estoni\u00e0" },
            { "Hanb", "han amb bopomofo" },
            { "eu", "basc" },
            { "Buhd", "buhid" },
            { "Hang", "hangul" },
            { "Samr", "samarit\u00e0" },
            { "shi", "taixelhit" },
            { "hsb", "alt s\u00f2rab" },
            { "Hani", "han" },
            { "%%ULSTER", "ulster" },
            { "shn", "xan" },
            { "Hano", "hanunoo" },
            { "fa", "persa" },
            { "Hans", "simplificat" },
            { "type.nu.latn", "d\u00edgits ar\u00e0bics" },
            { "Hant", "tradicional" },
            { "ff", "ful" },
            { "shu", "\u00e0rab txadi\u00e0" },
            { "hsn", "xin\u00e8s xiang" },
            { "fi", "fin\u00e8s" },
            { "fj", "fiji\u00e0" },
            { "fon", "fon" },
            { "bgn", "balutxi occidental" },
            { "yue", "canton\u00e8s" },
            { "fo", "fero\u00e8s" },
            { "type.m0.bgn", "sistema de transliteraci\u00f3 BGN" },
            { "umb", "umbundu" },
            { "fr", "franc\u00e8s" },
            { "sid", "sidamo" },
            { "fy", "fris\u00f3 occidental" },
            { "ga", "irland\u00e8s" },
            { "gd", "ga\u00e8lic escoc\u00e8s" },
            { "gl", "gallec" },
            { "gn", "guaran\u00ed" },
            { "bho", "bhojpuri" },
            { "und", "idioma desconegut" },
            { "type.ca.ethiopic-amete-alem", "calendari et\u00edop amete-alem" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "haussa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bicol" },
            { "bin", "edo" },
            { "ho", "hiri motu" },
            { "hr", "croat" },
            { "ht", "crioll d\u2019Hait\u00ed" },
            { "hu", "hongar\u00e8s" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "frc", "franc\u00e8s cajun" },
            { "%%FONIPA", "alfabet fon\u00e8tic internacional" },
            { "ia", "interlingua" },
            { "Jamo", "jamo" },
            { "id", "indonesi" },
            { "type.nu.tibt", "d\u00edgits tibetans" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "yi sichuan" },
            { "frm", "franc\u00e8s mitj\u00e0" },
            { "%%RUMGR", "interomanx" },
            { "ik", "inupiak" },
            { "fro", "franc\u00e8s antic" },
            { "io", "ido" },
            { "frs", "fris\u00f3 oriental" },
            { "frr", "fris\u00f3 septentrional" },
            { "is", "island\u00e8s" },
            { "it", "itali\u00e0" },
            { "iu", "inuktitut" },
            { "%%HOGNORSK", "h\u00f8gnorsk" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "sud-ar\u00e0bic antic" },
            { "Sara", "sarati" },
            { "doi", "dogri" },
            { "type.nu.lepc", "d\u00edgits lepcha" },
            { "bkm", "kom" },
            { "sma", "sami meridional" },
            { "jv", metaValue_jv },
            { "Shaw", "shavi\u00e0" },
            { "%%BAUDDHA", "bauddha" },
            { "mad", "madur\u00e8s" },
            { "smj", "sami lule" },
            { "mag", "magahi" },
            { "maf", "mafa" },
            { "mai", "maithili" },
            { "smn", "sami d\u2019Inari" },
            { "ka", metaValue_ka },
            { "bla", "blackfoot" },
            { "mak", "makassar" },
            { "wuu", "xin\u00e8s wu" },
            { "sms", "sami skolt" },
            { "man", "mandinga" },
            { "kg", "kongo" },
            { "Goth", metaValue_got },
            { "ki", "kikuiu" },
            { "mas", "massai" },
            { "kj", "kuanyama" },
            { "kk", "kazakh" },
            { "kl", "groenland\u00e8s" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "caixmiri" },
            { "Cirt", "cirth" },
            { "Lepc", "lepcha" },
            { "Avst", metaValue_ae },
            { "ku", "kurd" },
            { "kv", "komi" },
            { "kw", "c\u00f2rnic" },
            { "ky", "kirgu\u00eds" },
            { "snk", "soninke" },
            { "Mult", "multani" },
            { "la", metaValue_la },
            { "lb", "luxemburgu\u00e8s" },
            { "type.nu.mlym", "d\u00edgits malai\u00e0lam" },
            { "lg", "ganda" },
            { "Roro", "rongo-rongo" },
            { "li", "limburgu\u00e8s" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "fri\u00fcl\u00e0" },
            { "lo", "laosi\u00e0" },
            { "type.ms.uksystem", "sistema imperial d\u2019unitats" },
            { "type.nu.lana", "d\u00edgits tai tham hora" },
            { "lt", "litu\u00e0" },
            { "lu", "luba katanga" },
            { "lv", "let\u00f3" },
            { "sog", "sogdi\u00e0" },
            { "mg", "malgaix" },
            { "mh", "marshall\u00e8s" },
            { "type.co.ducet", "ordenaci\u00f3 Unicode predeterminada" },
            { "mi", "maori" },
            { "mk", "macedoni" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malai" },
            { "mt", "malt\u00e8s" },
            { "my", metaValue_my },
            { "Saur", "saurashtra" },
            { "Armn", metaValue_hy },
            { "mdf", "mordovi\u00e0 moksa" },
            { "mde", "maba" },
            { "dsb", "baix s\u00f2rab" },
            { "Armi", "arameu imperial" },
            { "na", "nauru\u00e0" },
            { "type.co.search", "cerca de prop\u00f2sit general" },
            { "nb", "noruec bokm\u00e5l" },
            { "nd", "ndebele septentrional" },
            { "ne", "nepal\u00e8s" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "neerland\u00e8s" },
            { "nn", "noruec nynorsk" },
            { "no", "noruec" },
            { "nr", "ndebele meridional" },
            { "Osge", metaValue_osa },
            { "nv", "navaho" },
            { "kaa", "karakalpak" },
            { "ny", "nyanja" },
            { "kac", "katxin" },
            { "kab", "cabilenc" },
            { "%%POLYTON", "polit\u00f2nic" },
            { "oc", "occit\u00e0" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", metaValue_men },
            { "oj", "ojibwa" },
            { "mer", "meru" },
            { "type.nu.armn", "nombres armenis" },
            { "om", "oromo" },
            { "kaw", "kawi" },
            { "or", metaValue_or },
            { "Modi", "modi" },
            { "os", "osseta" },
            { "%%ALALC97", "romanitzaci\u00f3 ALA/LC, edici\u00f3 de 1997" },
            { "kbd", "kabard\u00ed" },
            { "mfe", "maurici\u00e0" },
            { "srn", "sranan" },
            { "pa", "panjabi" },
            { "dua", "douala" },
            { "srr", "serer" },
            { "%%LIPAW", "dialecte Lipovaz del resi\u00e0" },
            { "kbl", "kanembu" },
            { "pi", "pali" },
            { "pl", "polon\u00e8s" },
            { "dum", "neerland\u00e8s mitj\u00e0" },
            { "type.nu.saur", "d\u00edgits saurashtra" },
            { "type.ca.dangi", "calendari dangi" },
            { "%%VALLADER", "baix engiadin\u00e8s" },
            { "ps", "paixtu" },
            { "pt", "portugu\u00e8s" },
            { "mga", "ga\u00e8lic irland\u00e8s mitj\u00e0" },
            { "key.co", "ordenaci\u00f3" },
            { "pt_BR", "portugu\u00e8s del Brasil" },
            { "kcg", "tyap" },
            { "mgh", "makhuwa-metto" },
            { "key.cf", "format de moneda" },
            { "type.nu.nkoo", "d\u00edgits n\u2019ko" },
            { "bra", "braj" },
            { "key.ca", "calendari" },
            { "%%JAUER", "jauer" },
            { "Laoo", "lao" },
            { "%%SURMIRAN", "surmiran" },
            { "mgo", "meta\u2019" },
            { "type.hc.h23", "sistema de 24 hores (0\u201323)" },
            { "type.hc.h24", "sistema de 24 hores (1\u201324)" },
            { "ssy", metaValue_ssy },
            { "brh", "brahui" },
            { "type.nu.mymr", "d\u00edgits de Myanmar" },
            { "qu", "qu\u00edtxua" },
            { "zap", "zapoteca" },
            { "brx", "bodo" },
            { "Lana", "lanna" },
            { "kde", "makonde" },
            { "%%VAIDIKA", "v\u00e8dic" },
            { "Ethi", "eti\u00f2pic" },
            { "%%JYUTPING", "jyupting" },
            { "type.hc.h12", "sistema de 12 hores (1\u201312)" },
            { "type.hc.h11", "sistema de 12 hores (0\u201311)" },
            { "rm", "retorom\u00e0nic" },
            { "rn", "rundi" },
            { "key.cu", "moneda" },
            { "ro", "roman\u00e8s" },
            { "%%SAAHO", metaValue_ssy },
            { "type.nu.orya", "d\u00edgits oriya" },
            { "type.nu.hanidec", "nombres decimals xinesos" },
            { "ru", "rus" },
            { "bss", "akoose" },
            { "zbl", metaValue_zbl },
            { "rw", "ruand\u00e8s" },
            { "kea", "crioll capverdi\u00e0" },
            { "mic", "micmac" },
            { "suk", "sukuma" },
            { "en_AU", "angl\u00e8s australi\u00e0" },
            { "Dupl", "taquigrafia Duploy\u00e9" },
            { "sa", "s\u00e0nscrit" },
            { "%%UCCOR", "ortografia unificada" },
            { "sc", "sard" },
            { "sus", "sus\u00fa" },
            { "sd", "sindi" },
            { "se", "sami septentrional" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "sh", "serbocroat" },
            { "ken", "kenyang" },
            { "si", metaValue_si },
            { "sux", "sumeri" },
            { "sk", "eslovac" },
            { "sl", "eslov\u00e8" },
            { "Gran", "grantha" },
            { "sm", "samo\u00e0" },
            { "sn", "shona" },
            { "so", "somali" },
            { "type.nu.arab", "xifres indoar\u00e0bigues" },
            { "sq", "alban\u00e8s" },
            { "sr", "serbi" },
            { "ss", "swazi" },
            { "type.cf.account", "format de moneda comptable" },
            { "Java", metaValue_jv },
            { "st", "sotho meridional" },
            { "su", "sondan\u00e8s" },
            { "%%NEDIS", "dialecte de Natisone" },
            { "sv", "suec" },
            { "sw", "suahili" },
            { "type.nu.hantfin", "nombres financers xinesos tradicionals" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", metaValue_ta },
            { "142", "\u00c0sia" },
            { "bua", "buriat" },
            { "143", "\u00c0sia central" },
            { "te", metaValue_te },
            { "145", "\u00c0sia occidental" },
            { "tg", "tadjik" },
            { "th", "tai" },
            { "ti", "tigrinya" },
            { "bug", "bugui" },
            { "kfo", "koro" },
            { "en_CA", "angl\u00e8s canadenc" },
            { "tk", "turcman" },
            { "tl", "tagal" },
            { "tn", "setswana" },
            { "to", "tongal\u00e8s" },
            { "bum", "bulu" },
            { "dyo", "diola" },
            { "type.nu.jpan", "nombres japonesos" },
            { "tr", "turc" },
            { "Cakm", metaValue_ccp },
            { "ts", "tsonga" },
            { "swb", "comori\u00e0" },
            { "tt", "t\u00e0tar" },
            { "dyu", "jula" },
            { "tw", "twi" },
            { "ty", "tahiti\u00e0" },
            { "%%BISKE", "dialecte de San Giorgio/Bila" },
            { "150", "Europa" },
            { "151", "Europa oriental" },
            { "154", "Europa septentrional" },
            { "dzg", "dazaga" },
            { "155", "Europa occidental" },
            { "ug", "uigur" },
            { "Kore", metaValue_ko },
            { "Ital", "cursiva antiga" },
            { "kgp", "kaing\u00e0" },
            { "Zyyy", "com\u00fa" },
            { "uk", "ucra\u00efn\u00e8s" },
            { "zea", "zeland\u00e8s" },
            { "type.ca.coptic", "calendari copte" },
            { "ur", "urd\u00fa" },
            { "%%1994", "ortografia resiana estandarditzada" },
            { "xal", "calmuc" },
            { "zen", "zenaga" },
            { "uz", "uzbek" },
            { "kha", "khasi" },
            { "%%1996", "ortografia alemanya de 1996" },
            { "nds_NL", "baix sax\u00f3" },
            { "Sylo", "syloti nagri" },
            { "ve", "venda" },
            { "Wara", "varang kshiti" },
            { "type.ca.roc", "calendari de la Rep\u00fablica de Xina" },
            { "vi", "vietnamita" },
            { "kho", "khotan\u00e8s" },
            { "khq", "koyra chiini" },
            { "key.hc", "sistema horari (12 h o 24 h)" },
            { "%%TARASK", "ortografia taraskievica" },
            { "vo", "volap\u00fck" },
            { "syc", "sir\u00edac cl\u00e0ssic" },
            { "Osma", "osmanya" },
            { "quc", "k\u2019iche\u2019" },
            { "Newa", "newar" },
            { "gaa", "ga" },
            { "wa", "val\u00f3" },
            { "gag", "gaga\u00fas" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "gan", "xin\u00e8s gan" },
            { "Lydi", "lidi" },
            { "Xsux", "cune\u00efforme sumeri-accadi" },
            { "wo", "w\u00f2lof" },
            { "zgh", "amazic est\u00e0ndard marroqu\u00ed" },
            { "ar_001", "\u00e0rab est\u00e0ndard modern" },
            { "Cans", "s\u00edl\u00b7labes dels abor\u00edgens canadencs unificats" },
            { "%%FONXSAMP", "sistema X-SAMPA" },
            { "gay", "gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "manx\u00fa" },
            { "Latf", "llat\u00ed fraktur" },
            { "szl", "silesi\u00e0" },
            { "Hluw", "jerogl\u00edfic anatoli" },
            { "gba", "gbaya" },
            { "mni", metaValue_mni },
            { "Latn", metaValue_la },
            { "Latg", "llat\u00ed ga\u00e8lic" },
            { "type.nu.hans", "nombres xinesos simplificats" },
            { "type.nu.hant", "nombres xinesos tradicionals" },
            { "xh", "xosa" },
            { "type.nu.romanlow", "nombres romans en min\u00fascula" },
            { "byn", "bilin" },
            { "%%PAMAKA", "dialecte pamaka" },
            { "Lyci", "lici" },
            { "osa", metaValue_osa },
            { "byv", "medumba" },
            { "Moon", "moon" },
            { "moh", "mohawk" },
            { "kkj", "kako" },
            { "%%1694ACAD", "franc\u00e8s modern primerenc" },
            { "Syrc", metaValue_syr },
            { "yi", "\u00eddix" },
            { "mos", "moore" },
            { "Dsrt", "deseret" },
            { "yo", "ioruba" },
            { "type.nu.traditional", "Numerals tradicionals" },
            { "es_MX", "espanyol de M\u00e8xic" },
            { "Syrj", "sir\u00edac occidental" },
            { "ota", "turc otom\u00e0" },
            { "Syre", "sir\u00edac estrangelo" },
            { "vai", metaValue_vai },
            { "za", "zhuang" },
            { "Cari", "cari\u00e0" },
            { "kln", "kalenjin" },
            { "zh", "xin\u00e8s" },
            { "Afak", "afaka" },
            { "Bopo", "bopomofo" },
            { "Perm", "antic p\u00e8rmic" },
            { "key.lb", "estil de salt de l\u00ednia" },
            { "zu", "zulu" },
            { "type.co.phonebook", "ordre de la guia telef\u00f2nica" },
            { "%%MONOTON", "monot\u00f2nic" },
            { "Geor", metaValue_ka },
            { "Shrd", "shrada" },
            { "kmb", "kimbundu" },
            { "type.nu.jpanfin", "nombres financers japonesos" },
            { "Cham", "cham" },
            { "gez", "gueez" },
            { "mrj", "mari occidental" },
            { "Syrn", "sir\u00edac oriental" },
            { "type.nu.mymrshan", "d\u00edgits shan de Myanmar" },
            { "Elba", "elbasan" },
            { "Narb", "antic nord-ar\u00e0bic" },
            { "type.nu.olck", "d\u00edgits ol chiki" },
            { "type.co.reformed", "ordenaci\u00f3 reformada" },
            { "Tglg", "tag\u00e0log" },
            { "Egyd", "dem\u00f2tic egipci" },
            { "Egyh", "hier\u00e0tic egipci" },
            { "%%ITIHASA", "itihasa" },
            { "Palm", "palmir\u00e8" },
            { "ebu", "embu" },
            { "Egyp", "jerogl\u00edfic egipci" },
            { "Geok", "georgi\u00e0 hucuri" },
            { "zh_Hans", "xin\u00e8s simplificat" },
            { "koi", "komi-permiac" },
            { "Hung", "hongar\u00e8s antic" },
            { "kok", "concani" },
            { "%%1901", "ortografia alemanya tradicional" },
            { "kos", "kosrae\u00e0" },
            { "vec", "v\u00e8net" },
            { "type.nu.limb", "d\u00edgits limbu" },
            { "zh_Hant", "xin\u00e8s tradicional" },
            { "Sund", "sundan\u00e8s" },
            { "vep", "vepse" },
            { "kpe", metaValue_kpe },
            { "type.nu.khmr", "d\u00edgits khmer" },
            { "Tirh", "tirhut" },
            { "ilo", "ilocano" },
            { "%%VALENCIA", "valenci\u00e0" },
            { "Cprt", "xipriota" },
            { "%%BAKU1926", "alfabet llat\u00ed turc unificat" },
            { "mua", "mundang" },
            { "type.nu.guru", "d\u00edgits gurmukhi" },
            { "mul", "lleng\u00fces v\u00e0ries" },
            { "%%PUTER", "alt engiadin\u00e8s" },
            { "cad", "caddo" },
            { "key.ms", "sistema de mesures" },
            { "mus", "creek" },
            { "Glag", "glagol\u00edtic" },
            { "gil", "gilbert\u00e8s" },
            { "%%KKCOR", "ortografia comuna" },
            { "Cher", metaValue_chr },
            { "car", "carib" },
            { "cay", "cayuga" },
            { "type.nu.tamldec", "d\u00edgits tamils" },
            { "krc", "karatxai-balkar" },
            { "inh", "ing\u00faix" },
            { "kri", "krio" },
            { "fa_AF", "dari" },
            { "krl", "careli\u00e0" },
            { "efi", "efik" },
            { "key.nu", "xifres" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
