/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.skin;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.tk.Toolkit;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.animation.FadeTransition;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.StyleOrigin;
import javafx.css.StyleableObjectProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Cell;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Skinnable;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.skin.CellSkinBase;
import javafx.scene.control.skin.VirtualFlow;
import javafx.util.Duration;

public abstract class TableRowSkinBase<T, C extends IndexedCell, R extends IndexedCell>
extends CellSkinBase<C> {
    private static boolean IS_STUB_TOOLKIT = Toolkit.getToolkit().toString().contains("StubToolkit");
    private static boolean DO_ANIMATIONS = !IS_STUB_TOOLKIT && !PlatformUtil.isEmbedded();
    private static final Duration FADE_DURATION = Duration.millis((double)200.0);
    static final Map<TableColumnBase<?, ?>, Double> maxDisclosureWidthMap = new WeakHashMap();
    private static final int DEFAULT_FULL_REFRESH_COUNTER = 100;
    WeakHashMap<TableColumnBase, Reference<R>> cellsMap;
    final List<R> cells = new ArrayList<R>();
    private int fullRefreshCounter = 100;
    boolean isDirty = false;
    boolean updateCells = false;
    double fixedCellSize;
    boolean fixedCellSizeEnabled;

    public TableRowSkinBase(C c) {
        super(c);
        ((IndexedCell)this.getSkinnable()).setPickOnBounds(false);
        this.recreateCells();
        this.updateCells(true);
        this.registerListChangeListener(this.getVisibleLeafColumns(), change -> this.updateLeafColumns());
        this.registerInvalidationListener((Observable)((Cell)c).itemProperty(), observable -> this.requestCellUpdate());
        this.registerChangeListener((ObservableValue<?>)((IndexedCell)c).indexProperty(), observableValue -> {
            if (((IndexedCell)this.getSkinnable()).isEmpty()) {
                this.requestCellUpdate();
            }
        });
    }

    private void updateLeafColumns() {
        this.isDirty = true;
        ((IndexedCell)this.getSkinnable()).requestLayout();
    }

    protected abstract R createCell(TableColumnBase<T, ?> var1);

    protected abstract void updateCell(R var1, C var2);

    protected abstract TableColumnBase<T, ?> getTableColumn(R var1);

    protected abstract ObservableList<? extends TableColumnBase> getVisibleLeafColumns();

    protected ObjectProperty<Node> graphicProperty() {
        return null;
    }

    @Override
    protected void layoutChildren(double d, double d2, double d3, double d4) {
        int n;
        double d5;
        this.checkState();
        if (this.cellsMap.isEmpty()) {
            return;
        }
        ObservableList<TableColumnBase> observableList = this.getVisibleLeafColumns();
        if (observableList.isEmpty()) {
            super.layoutChildren(d, d2, d3, d4);
            return;
        }
        IndexedCell indexedCell = (IndexedCell)this.getSkinnable();
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        boolean bl = this.isIndentationRequired();
        boolean bl2 = this.isDisclosureNodeVisible();
        int n2 = 0;
        Node node = null;
        if (bl) {
            double d9;
            TableColumnBase tableColumnBase = this.getTreeColumn();
            n2 = tableColumnBase == null ? 0 : observableList.indexOf((Object)tableColumnBase);
            n2 = n2 < 0 ? 0 : n2;
            int n3 = this.getIndentationLevel(indexedCell);
            if (!this.isShowRoot()) {
                --n3;
            }
            d5 = this.getIndentationPerLevel();
            d6 = (double)n3 * d5;
            d7 = d9 = maxDisclosureWidthMap.containsKey(tableColumnBase) ? maxDisclosureWidthMap.get(tableColumnBase) : 0.0;
            node = this.getDisclosureNode();
            if (node != null) {
                node.setVisible(bl2);
                if (bl2 && (d7 = node.prefWidth(d4)) > d9) {
                    maxDisclosureWidthMap.put(tableColumnBase, d7);
                    VirtualFlow<C> virtualFlow = this.getVirtualFlow();
                    int n4 = ((IndexedCell)this.getSkinnable()).getIndex();
                    for (int i = 0; i < virtualFlow.cells.size(); ++i) {
                        IndexedCell indexedCell2 = (IndexedCell)virtualFlow.cells.get(i);
                        if (indexedCell2 == null || indexedCell2.isEmpty()) continue;
                        indexedCell2.requestLayout();
                        indexedCell2.layout();
                    }
                }
            }
        }
        if ((n = indexedCell.getIndex()) < 0) {
            return;
        }
        int n5 = this.cells.size();
        for (int i = 0; i < n5; ++i) {
            double d10;
            IndexedCell indexedCell3 = (IndexedCell)this.cells.get(i);
            TableColumnBase<T, ?> tableColumnBase = this.getTableColumn(indexedCell3);
            boolean bl3 = true;
            if (this.fixedCellSizeEnabled) {
                bl3 = this.isColumnPartiallyOrFullyVisible(tableColumnBase);
                d2 = 0.0;
                d5 = this.fixedCellSize;
            } else {
                d5 = d4;
            }
            if (bl3) {
                if (this.fixedCellSizeEnabled && indexedCell3.getParent() == null) {
                    this.getChildren().add((Object)indexedCell3);
                }
                d10 = indexedCell3.prefWidth(d5);
                boolean bl4 = d5 <= 24.0;
                StyleOrigin styleOrigin = ((StyleableObjectProperty)indexedCell3.alignmentProperty()).getStyleOrigin();
                if (!bl4 && styleOrigin == null) {
                    indexedCell3.setAlignment(Pos.TOP_LEFT);
                }
                if (bl && i == n2) {
                    ObjectProperty<Node> objectProperty;
                    Node node2;
                    if (bl2) {
                        double d11 = node.prefHeight(d7);
                        if (d10 > 0.0 && d10 < d7 + d6) {
                            this.fadeOut(node);
                        } else {
                            this.fadeIn(node);
                            node.resize(d7, d11);
                            node.relocate(d + d6, bl4 ? d2 + (d4 / 2.0 - d11 / 2.0) : d2 + indexedCell3.getPadding().getTop());
                            node.toFront();
                        }
                    }
                    Node node3 = node2 = (objectProperty = this.graphicProperty()) == null ? null : (Node)objectProperty.get();
                    if (node2 != null) {
                        d8 = node2.prefWidth(-1.0) + 3.0;
                        double d12 = node2.prefHeight(d8);
                        if (d10 > 0.0 && d10 < d7 + d6 + d8) {
                            this.fadeOut(node2);
                        } else {
                            this.fadeIn(node2);
                            node2.relocate(d + d6 + d7, bl4 ? d4 / 2.0 - d12 / 2.0 : d2 + indexedCell3.getPadding().getTop());
                            node2.toFront();
                        }
                    }
                }
                indexedCell3.resize(d10, d5);
                indexedCell3.relocate(d, d2);
                indexedCell3.requestLayout();
            } else {
                d10 = indexedCell3.prefWidth(d5);
                if (this.fixedCellSizeEnabled) {
                    this.getChildren().remove((Object)indexedCell3);
                }
            }
            d += d10;
        }
    }

    int getIndentationLevel(C c) {
        return 0;
    }

    double getIndentationPerLevel() {
        return 0.0;
    }

    boolean isIndentationRequired() {
        return false;
    }

    TableColumnBase getTreeColumn() {
        return null;
    }

    Node getDisclosureNode() {
        return null;
    }

    boolean isDisclosureNodeVisible() {
        return false;
    }

    boolean isShowRoot() {
        return true;
    }

    void updateCells(boolean bl) {
        Object object;
        if (bl) {
            if (this.fullRefreshCounter == 0) {
                this.recreateCells();
            }
            --this.fullRefreshCounter;
        }
        boolean bl2 = this.cells.isEmpty();
        this.cells.clear();
        IndexedCell indexedCell = (IndexedCell)this.getSkinnable();
        int n = indexedCell.getIndex();
        ObservableList<TableColumnBase> observableList = this.getVisibleLeafColumns();
        int n2 = observableList.size();
        for (int i = 0; i < n2; ++i) {
            TableColumnBase tableColumnBase = (TableColumnBase)observableList.get(i);
            object = null;
            if (this.cellsMap.containsKey(tableColumnBase) && (object = (IndexedCell)this.cellsMap.get(tableColumnBase).get()) == null) {
                this.cellsMap.remove(tableColumnBase);
            }
            if (object == null) {
                object = this.createCellAndCache(tableColumnBase);
            }
            this.updateCell(object, indexedCell);
            ((IndexedCell)object).updateIndex(n);
            this.cells.add(object);
        }
        if (this.fixedCellSizeEnabled) {
            ArrayList<TableColumnBase> arrayList = new ArrayList<TableColumnBase>();
            for (TableColumnBase tableColumnBase : this.getChildren()) {
                if (!(tableColumnBase instanceof IndexedCell)) continue;
                object = this.getTableColumn((IndexedCell)((Object)tableColumnBase));
                if (this.getVisibleLeafColumns().contains(object)) continue;
                arrayList.add(tableColumnBase);
            }
            this.getChildren().removeAll(arrayList);
        } else if (bl || bl2) {
            this.getChildren().setAll(this.cells);
        }
    }

    VirtualFlow<C> getVirtualFlow() {
        for (Skinnable skinnable = this.getSkinnable(); skinnable != null; skinnable = skinnable.getParent()) {
            if (!(skinnable instanceof VirtualFlow)) continue;
            return (VirtualFlow)((Object)skinnable);
        }
        return null;
    }

    @Override
    protected double computePrefWidth(double d, double d2, double d3, double d4, double d5) {
        double d6 = d5 + d3;
        for (IndexedCell indexedCell : this.cells) {
            d6 += indexedCell.prefWidth(d);
        }
        return d6;
    }

    @Override
    protected double computePrefHeight(double d, double d2, double d3, double d4, double d5) {
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        this.checkState();
        double d6 = this.getCellSize() + d2 + d4;
        if (this.getCellSize() < 24.0) {
            return d6;
        }
        double d7 = 0.0;
        int n = this.cells.size();
        for (int i = 0; i < n; ++i) {
            IndexedCell indexedCell = (IndexedCell)this.cells.get(i);
            d7 = Math.max(d7, indexedCell.prefHeight(-1.0));
        }
        double d8 = Math.max(d6, ((IndexedCell)this.getSkinnable()).minHeight(-1.0));
        double d9 = Math.max(d7 += d2 + d4, d8);
        return d9;
    }

    @Override
    protected double computeMinHeight(double d, double d2, double d3, double d4, double d5) {
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        this.checkState();
        if (this.getCellSize() < 24.0) {
            return this.getCellSize() + d2 + d4;
        }
        double d6 = 0.0;
        int n = this.cells.size();
        for (int i = 0; i < n; ++i) {
            IndexedCell indexedCell = (IndexedCell)this.cells.get(i);
            d6 = Math.max(d6, indexedCell.minHeight(-1.0));
        }
        return d6 += d2 + d4;
    }

    @Override
    protected double computeMaxHeight(double d, double d2, double d3, double d4, double d5) {
        if (this.fixedCellSizeEnabled) {
            return this.fixedCellSize;
        }
        return super.computeMaxHeight(d, d2, d3, d4, d5);
    }

    final void checkState() {
        if (this.isDirty) {
            this.updateCells(true);
            this.isDirty = false;
            this.updateCells = false;
        } else if (this.updateCells) {
            this.updateCells(false);
            this.updateCells = false;
        }
    }

    boolean isDirty() {
        return this.isDirty;
    }

    void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    private boolean isColumnPartiallyOrFullyVisible(TableColumnBase tableColumnBase) {
        TableColumnBase tableColumnBase2;
        if (tableColumnBase == null || !tableColumnBase.isVisible()) {
            return false;
        }
        VirtualFlow<C> virtualFlow = this.getVirtualFlow();
        double d = virtualFlow == null ? 0.0 : virtualFlow.getHbar().getValue();
        double d2 = 0.0;
        ObservableList<TableColumnBase> observableList = this.getVisibleLeafColumns();
        int n = observableList.size();
        for (int i = 0; i < n && !(tableColumnBase2 = (TableColumnBase)observableList.get(i)).equals(tableColumnBase); ++i) {
            d2 += tableColumnBase2.getWidth();
        }
        double d3 = d2 + tableColumnBase.getWidth();
        tableColumnBase2 = ((IndexedCell)this.getSkinnable()).getPadding();
        double d4 = ((IndexedCell)this.getSkinnable()).getWidth() - tableColumnBase2.getLeft() + tableColumnBase2.getRight();
        return (d2 >= d || d3 > d) && (d2 < d4 + d || d3 <= d4 + d);
    }

    private void requestCellUpdate() {
        this.updateCells = true;
        ((IndexedCell)this.getSkinnable()).requestLayout();
        int n = ((IndexedCell)this.getSkinnable()).getIndex();
        int n2 = this.cells.size();
        for (int i = 0; i < n2; ++i) {
            ((IndexedCell)this.cells.get(i)).updateIndex(n);
        }
    }

    private void recreateCells() {
        Object object;
        Iterator iterator;
        Object object2;
        if (this.cellsMap != null) {
            object2 = this.cellsMap.values();
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (Reference)iterator.next();
                IndexedCell indexedCell = (IndexedCell)((Reference)object).get();
                if (indexedCell == null) continue;
                indexedCell.updateIndex(-1);
                indexedCell.getSkin().dispose();
                indexedCell.setSkin(null);
            }
            this.cellsMap.clear();
        }
        object2 = this.getVisibleLeafColumns();
        this.cellsMap = new WeakHashMap(object2.size());
        this.fullRefreshCounter = 100;
        this.getChildren().clear();
        iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = (TableColumnBase)iterator.next();
            if (this.cellsMap.containsKey(object)) continue;
            this.createCellAndCache((TableColumnBase<T, ?>)object);
        }
    }

    private R createCellAndCache(TableColumnBase<T, ?> tableColumnBase) {
        R r = this.createCell(tableColumnBase);
        this.cellsMap.put(tableColumnBase, new WeakReference<R>(r));
        return r;
    }

    private void fadeOut(Node node) {
        if (node.getOpacity() < 1.0) {
            return;
        }
        if (!DO_ANIMATIONS) {
            node.setOpacity(0.0);
            return;
        }
        FadeTransition fadeTransition = new FadeTransition(FADE_DURATION, node);
        fadeTransition.setToValue(0.0);
        fadeTransition.play();
    }

    private void fadeIn(Node node) {
        if (node.getOpacity() > 0.0) {
            return;
        }
        if (!DO_ANIMATIONS) {
            node.setOpacity(1.0);
            return;
        }
        FadeTransition fadeTransition = new FadeTransition(FADE_DURATION, node);
        fadeTransition.setToValue(1.0);
        fadeTransition.play();
    }
}

