/*
 * Decompiled with CFR 0.152.
 */
package ru.rk.waitmain;

import cpw.mods.fml.relauncher.IClassTransformer;
import java.io.File;
import java.io.FileWriter;
import java.util.List;
import java.util.ListIterator;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class WaitMainTransformer
implements IClassTransformer {
    private static final String MC_CLASS = "net.minecraft.client.Minecraft";
    private static final String LEGACY_LAUNCH = "pro.gravit.utils.launch.LegacyLaunch";
    private static final String ENTRYPOINT = "pro.gravit.launcher.client.ClientLauncherEntryPoint";
    private static final String NEED_SERVER_TEXT = "Client asked for parameter: server";

    private static void log(String string) {
        try {
            File file = new File(System.getProperty("user.home"), "waitmain_coremod.log");
            FileWriter fileWriter = new FileWriter(file, true);
            fileWriter.write(string + "\n");
            fileWriter.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public byte[] transform(String string, byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (!(MC_CLASS.equals(string) || LEGACY_LAUNCH.equals(string) || ENTRYPOINT.equals(string))) {
            return byArray;
        }
        try {
            boolean bl;
            ClassNode classNode = new ClassNode();
            new ClassReader(byArray).accept((ClassVisitor)classNode, 0);
            boolean bl2 = false;
            boolean bl3 = WaitMainTransformer.patchAskedForServerReturn(classNode);
            if (bl3) {
                bl2 = true;
                WaitMainTransformer.log("[WaitMain] Patched 'asked for parameter: server' early-exit in " + string);
            }
            if (MC_CLASS.equals(string) && (bl = WaitMainTransformer.injectWaitBeforeReturnInMinecraftMain(classNode))) {
                bl2 = true;
                WaitMainTransformer.log("[WaitMain] Injected Waiter.await() before RETURN in Minecraft.main");
            }
            if (!bl2) {
                return byArray;
            }
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        catch (Throwable throwable) {
            WaitMainTransformer.log("[WaitMain] ERROR in transform(" + string + "): " + throwable.getClass().getName() + ": " + String.valueOf(throwable.getMessage()));
            return byArray;
        }
    }

    private static boolean patchAskedForServerReturn(ClassNode classNode) {
        boolean bl = false;
        List list = classNode.methods;
        block0: for (MethodNode methodNode : list) {
            Object object;
            AbstractInsnNode abstractInsnNode = null;
            ListIterator listIterator = methodNode.instructions.iterator();
            while (listIterator.hasNext()) {
                AbstractInsnNode abstractInsnNode2 = (AbstractInsnNode)listIterator.next();
                if (!(abstractInsnNode2 instanceof LdcInsnNode) || !NEED_SERVER_TEXT.equals(object = ((LdcInsnNode)abstractInsnNode2).cst)) continue;
                abstractInsnNode = abstractInsnNode2;
                break;
            }
            if (abstractInsnNode == null) continue;
            for (listIterator = abstractInsnNode.getNext(); listIterator != null; listIterator = listIterator.getNext()) {
                int n = listIterator.getOpcode();
                if (n != 177 && n != 176 && n != 172 && n != 173 && n != 174 && n != 175) continue;
                object = listIterator;
                listIterator = listIterator.getNext();
                methodNode.instructions.remove((AbstractInsnNode)object);
                methodNode.instructions.insertBefore((AbstractInsnNode)listIterator, (AbstractInsnNode)new InsnNode(0));
                bl = true;
                WaitMainTransformer.log("[WaitMain] Removed return after NEED_SERVER_TEXT in method " + methodNode.name + methodNode.desc);
                continue block0;
            }
        }
        return bl;
    }

    private static boolean injectWaitBeforeReturnInMinecraftMain(ClassNode classNode) {
        boolean bl = false;
        List list = classNode.methods;
        for (MethodNode methodNode : list) {
            if (!"main".equals(methodNode.name) || !"([Ljava/lang/String;)V".equals(methodNode.desc)) continue;
            for (AbstractInsnNode abstractInsnNode : methodNode.instructions) {
                if (abstractInsnNode.getOpcode() != 177) continue;
                InsnList insnList = new InsnList();
                insnList.add((AbstractInsnNode)new MethodInsnNode(184, "ru/rk/waitmain/Waiter", "await", "()V"));
                methodNode.instructions.insertBefore(abstractInsnNode, insnList);
                bl = true;
            }
        }
        return bl;
    }
}

