/*
 * Copyright 2012 Mark Slater
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at
 *
 * 	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
 */

package argo.jdom;

import java.util.ArrayList;
import java.util.List;

import static java.util.Collections.unmodifiableList;

final class JsonArray extends AbstractJsonArray {

    private final List<JsonNode> elements;

    JsonArray(final Iterable<JsonNode> elements) {
        this.elements = unmodifiableList(new ArrayList<JsonNode>() {{
            for (JsonNode element : elements) {
                this.add(element);
            }
        }});
    }

    public List<JsonNode> getElements() {
        return elements;
    }

}
