/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MinecartRegistry {
    private static Map<MinecartKey, ur> itemForMinecart = new HashMap<MinecartKey, ur>();
    private static Map<ur, MinecartKey> minecartForItem = new HashMap<ur, MinecartKey>();

    public static void registerMinecart(Class<? extends py> cart, ur item) {
        MinecartRegistry.registerMinecart(cart, 0, item);
    }

    public static void registerMinecart(Class<? extends py> minecart, int type, ur item) {
        MinecartKey key = new MinecartKey(minecart, type);
        itemForMinecart.put(key, item);
        minecartForItem.put(item, key);
    }

    public static void removeMinecart(Class<? extends py> minecart, int type) {
        MinecartKey key = new MinecartKey(minecart, type);
        ur item = itemForMinecart.remove(key);
        if (item != null) {
            minecartForItem.remove(item);
        }
    }

    public static ur getItemForCart(Class<? extends py> minecart) {
        return MinecartRegistry.getItemForCart(minecart, 0);
    }

    public static ur getItemForCart(Class<? extends py> minecart, int type) {
        ur item = itemForMinecart.get(new MinecartKey(minecart, type));
        if (item == null) {
            return null;
        }
        return item.l();
    }

    public static ur getItemForCart(py cart) {
        return MinecartRegistry.getItemForCart(cart.getClass(), cart.getMinecartType());
    }

    public static Class<? extends py> getCartClassForItem(ur item) {
        MinecartKey key = null;
        for (Map.Entry<ur, MinecartKey> entry : minecartForItem.entrySet()) {
            if (!entry.getKey().a(item)) continue;
            key = entry.getValue();
            break;
        }
        if (key != null) {
            return key.minecart;
        }
        return null;
    }

    public static int getCartTypeForItem(ur item) {
        MinecartKey key = null;
        for (Map.Entry<ur, MinecartKey> entry : minecartForItem.entrySet()) {
            if (!entry.getKey().a(item)) continue;
            key = entry.getValue();
            break;
        }
        if (key != null) {
            return key.type;
        }
        return -1;
    }

    public static Set<ur> getAllCartItems() {
        HashSet<ur> ret = new HashSet<ur>();
        for (ur item : minecartForItem.keySet()) {
            ret.add(item.l());
        }
        return ret;
    }

    static {
        MinecartRegistry.registerMinecart(py.class, 0, new ur(up.az));
        MinecartRegistry.registerMinecart(py.class, 1, new ur(up.aN));
        MinecartRegistry.registerMinecart(py.class, 2, new ur(up.aO));
    }

    public static class MinecartKey {
        public final Class<? extends py> minecart;
        public final int type;

        public MinecartKey(Class<? extends py> cls, int typtID) {
            this.minecart = cls;
            this.type = typtID;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MinecartKey other = (MinecartKey)obj;
            if (!(this.minecart == other.minecart || this.minecart != null && this.minecart.equals(other.minecart))) {
                return false;
            }
            return this.type == other.type;
        }

        public int hashCode() {
            int hash = 7;
            hash = 59 * hash + (this.minecart != null ? this.minecart.hashCode() : 0);
            hash = 59 * hash + this.type;
            return hash;
        }
    }
}

